/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.generation_data.material_management;

import io.github.mikip98.humilityafm.util.generation_data.material_management.SizedIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class LayeredMaterialArrayCombiner
implements SizedIterable<BlockMaterial> {
    private final List<String[]>[] layersArray;
    private final List<BlockMaterial.Metadata[]> metadataArrays;

    @SafeVarargs
    public LayeredMaterialArrayCombiner(List<BlockMaterial.Metadata[]> metadataArrays, List<String[]> ... layers) {
        int i = 0;
        for (List<String[]> layer : layers) {
            if (layer.size() != metadataArrays.get(i).length) {
                throw new IllegalArgumentException("Metadata array size does not match the layer array amount at index " + i);
            }
            ++i;
        }
        this.layersArray = layers;
        this.metadataArrays = metadataArrays;
    }

    @SafeVarargs
    public LayeredMaterialArrayCombiner(List<String[]> ... layers) {
        int i = 0;
        this.metadataArrays = new ArrayList<BlockMaterial.Metadata[]>();
        for (List<String[]> layer : layers) {
            this.metadataArrays.add(new BlockMaterial.Metadata[layer.size()]);
            for (int j = 0; j < layer.size(); ++j) {
                this.metadataArrays.get((int)i)[j] = BlockMaterial.Metadata.empty();
            }
            ++i;
        }
        this.layersArray = layers;
    }

    @Override
    @NotNull
    public Iterator<BlockMaterial> iterator() {
        return new LayeredMarkedCombinatorIterator();
    }

    @Override
    public void forEach(Consumer<? super BlockMaterial> action) {
        for (BlockMaterial s : this) {
            action.accept(s);
        }
    }

    public <R> Iterable<R> map(final Function<? super BlockMaterial, ? extends R> mapper) {
        return () -> new Iterator<R>(){
            private final Iterator<BlockMaterial> baseIterator;
            {
                this.baseIterator = LayeredMaterialArrayCombiner.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIterator.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(this.baseIterator.next());
            }
        };
    }

    @Override
    public int size() {
        int count = 0;
        for (BlockMaterial ignored : this) {
            ++count;
        }
        return count;
    }

    private class LayeredMarkedCombinatorIterator
    implements Iterator<BlockMaterial> {
        int[] layerArrayIndexes;
        int[] layerElementIndexes;
        boolean stop;
        BlockMaterial nextValue;

        public LayeredMarkedCombinatorIterator() {
            this.layerArrayIndexes = new int[LayeredMaterialArrayCombiner.this.layersArray.length];
            this.layerElementIndexes = new int[LayeredMaterialArrayCombiner.this.layersArray.length];
            this.stop = false;
            this.nextValue = null;
            Arrays.fill(this.layerArrayIndexes, 0);
            Arrays.fill(this.layerElementIndexes, 0);
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            if (this.stop) {
                return false;
            }
            NameMetaPair[] pairs = new NameMetaPair[LayeredMaterialArrayCombiner.this.layersArray.length];
            do {
                for (int i = 0; i < LayeredMaterialArrayCombiner.this.layersArray.length; ++i) {
                    List<String[]> layer = LayeredMaterialArrayCombiner.this.layersArray[i];
                    BlockMaterial.Metadata[] layerMetadata = LayeredMaterialArrayCombiner.this.metadataArrays.get(i);
                    String name = layer.get(this.layerArrayIndexes[i])[this.layerElementIndexes[i]];
                    BlockMaterial.Metadata metadata = layerMetadata[this.layerArrayIndexes[i]];
                    pairs[i] = new NameMetaPair(name, metadata);
                }
                if (!LayeredMarkedCombinatorIterator.checkForUniqueness(pairs)) continue;
                ArrayList<BlockMaterial.Layer> layers = new ArrayList<BlockMaterial.Layer>();
                for (NameMetaPair pair : pairs) {
                    layers.add(new BlockMaterial.Layer(pair.name, pair.metadata));
                }
                this.nextValue = BlockMaterial.of((BlockMaterial.Layer[])layers.toArray(BlockMaterial.Layer[]::new));
                if (!this.advanceArrayIndexes()) {
                    this.stop = true;
                }
                return true;
            } while (this.advanceArrayIndexes());
            return false;
        }

        protected static boolean checkForUniqueness(NameMetaPair[] nameMetaPairs) {
            HashSet<NameMetaPair> seen = new HashSet<NameMetaPair>();
            boolean allUniquePairs = true;
            for (NameMetaPair nameMetaPair : nameMetaPairs) {
                if (seen.add(nameMetaPair)) continue;
                allUniquePairs = false;
                break;
            }
            return allUniquePairs;
        }

        @Override
        public BlockMaterial next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BlockMaterial result = this.nextValue;
            this.nextValue = null;
            return result;
        }

        private boolean advanceArrayIndexes() {
            int i = LayeredMaterialArrayCombiner.this.layersArray.length - 1;
            while (!this.advanceLayerIndexes(i)) {
                if (--i >= 0) continue;
                return false;
            }
            return true;
        }

        private boolean advanceLayerIndexes(int i) {
            int layerArrayIndex = this.layerArrayIndexes[i];
            int layerArrayAmount = LayeredMaterialArrayCombiner.this.layersArray[i].size();
            int layerElementIndex = this.layerElementIndexes[i];
            int currentArraySize = LayeredMaterialArrayCombiner.this.layersArray[i].get(layerArrayIndex).length;
            if (layerElementIndex + 1 < currentArraySize) {
                this.layerElementIndexes[i] = layerElementIndex + 1;
                return true;
            }
            this.layerElementIndexes[i] = 0;
            if (layerArrayIndex + 1 < layerArrayAmount) {
                this.layerArrayIndexes[i] = layerArrayIndex + 1;
                return true;
            }
            this.layerArrayIndexes[i] = 0;
            return false;
        }

        protected record NameMetaPair(String name, BlockMaterial.Metadata metadata) {
        }
    }
}

