/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.generation_data.material_management;

import io.github.mikip98.humilityafm.util.generation_data.material_management.SizedIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class MaterialMultiArrayIterable
implements SizedIterable<BlockMaterial> {
    private final String[][] arrays;
    private final BlockMaterial.Metadata[] metadataArray;

    public MaterialMultiArrayIterable(BlockMaterial.Metadata[] metadataArray, String[] ... arrays) {
        this.arrays = arrays;
        this.metadataArray = metadataArray;
    }

    public static MaterialMultiArrayIterable of(BlockMaterial.Metadata[] metadataArray, String[][] arrays) {
        return new MaterialMultiArrayIterable(metadataArray, arrays);
    }

    public MaterialMultiArrayIterable(String[] ... arrays) {
        this.arrays = arrays;
        this.metadataArray = new BlockMaterial.Metadata[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            this.metadataArray[i] = BlockMaterial.Metadata.empty();
        }
    }

    @Override
    @NotNull
    public Iterator<BlockMaterial> iterator() {
        return new MarkedMultiArrayIterator();
    }

    @Override
    public int size() {
        return Arrays.stream(this.arrays).mapToInt(array -> ((String[])array).length).sum();
    }

    private class MarkedMultiArrayIterator
    implements Iterator<BlockMaterial> {
        int arrayIndex = 0;
        int elementIndex = 0;

        private MarkedMultiArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.arrayIndex < MaterialMultiArrayIterable.this.arrays.length && this.elementIndex >= MaterialMultiArrayIterable.this.arrays[this.arrayIndex].length) {
                ++this.arrayIndex;
                this.elementIndex = 0;
            }
            return this.arrayIndex < MaterialMultiArrayIterable.this.arrays.length;
        }

        @Override
        public BlockMaterial next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return BlockMaterial.of(MaterialMultiArrayIterable.this.arrays[this.arrayIndex][this.elementIndex++], MaterialMultiArrayIterable.this.metadataArray[this.arrayIndex]);
        }
    }
}

