/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.mod_support;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.util.FunUtils;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.EnumSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class ModSupportManager {
    protected static Set<SupportedMods> loadedMods;

    public static boolean isModLoaded(SupportedMods mod) {
        return loadedMods.contains((Object)mod);
    }

    public static void init() {
        if (!ModConfig.datagenMode) {
            loadedMods = EnumSet.noneOf(SupportedMods.class);
            HumilityAFM.LOGGER.info("Checking for supported mods...");
            block5: for (SupportedMods mod : SupportedMods.values()) {
                switch (ModConfig.modSupport.get((Object)mod)) {
                    case AUTO: {
                        ModSupportManager.checkForMod(mod);
                        continue block5;
                    }
                    case ON: {
                        loadedMods.add(mod);
                        HumilityAFM.LOGGER.info("Supported mod '{}' ({}) has been enabled by configuration.", (Object)mod.modName, (Object)mod.modId);
                        continue block5;
                    }
                    case OFF: {
                        HumilityAFM.LOGGER.info("Supported mod '{}' ({}) has been disabled by configuration.", (Object)mod.modName, (Object)mod.modId);
                    }
                }
            }
        } else {
            loadedMods = EnumSet.allOf(SupportedMods.class);
            HumilityAFM.LOGGER.info("Datagen mode is enabled, all supported mods will be marked as loaded.");
        }
    }

    protected static void checkForMod(SupportedMods mod) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded(mod.modId)) {
            loadedMods.add(mod);
            HumilityAFM.LOGGER.info("Supported mod '{}' ({}) has been found present {}", new Object[]{mod.modName, mod.modId, FunUtils.getRandomFunSymbol()});
        }
    }
}

