/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.config.enums.CreativeItemGroupCategorization;
import io.github.mikip98.humilityafm.config.enums.ModSupportState;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigJSON {
    public static void saveConfigToFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        File configFile = new File(configDir, "humility-afm.json");
        JsonObject configJson = new JsonObject();
        configJson.addProperty("transparentCabinetBlocks", Boolean.valueOf(ModConfig.transparentCabinetBlocks));
        configJson.addProperty("illuminatedCabinetBlockBrightening", Boolean.valueOf(ModConfig.illuminatedCabinetBlockBrightening));
        configJson.addProperty("enableLightStripBrightening", Boolean.valueOf(ModConfig.enableLightStripBrightening));
        configJson.addProperty("enableLightStripRadiusColorCompensation", Boolean.valueOf(ModConfig.enableLightStripRadiusColorCompensation));
        configJson.addProperty("enableCandlestickBeta", Boolean.valueOf(ModConfig.getRawEnableCandlestickBeta()));
        configJson.addProperty("enableColouredFeatureSetBeta", Boolean.valueOf(ModConfig.getRawEnableColouredFeatureSetBeta()));
        configJson.addProperty("creativeItemGroupCategorization", ModConfig.creativeItemGroupCategorization.toString());
        configJson.addProperty("placeHumilityBlocksInVanillaCreativeCategories", Boolean.valueOf(ModConfig.placeHumilityBlocksInVanillaCreativeCategories));
        configJson.addProperty("mosaicsAndTilesStrengthMultiplayer", (Number)Float.valueOf(ModConfig.mosaicsAndTilesStrengthMultiplayer));
        configJson.addProperty("cabinetBlockBurnTime", (Number)ModConfig.cabinetBlockBurnTime);
        configJson.addProperty("cabinetBlockFireSpread", (Number)ModConfig.cabinetBlockFireSpread);
        configJson.addProperty("datagenMode", Boolean.valueOf(ModConfig.datagenMode));
        configJson.addProperty("printInChatServerClientMissmatch", Boolean.valueOf(ModConfig.printInChatServerClientMissmatch));
        JsonObject modSupportJson = new JsonObject();
        for (Map.Entry<SupportedMods, ModSupportState> entry : ModConfig.modSupport.entrySet()) {
            modSupportJson.addProperty(entry.getKey().modId, entry.getValue().toString());
        }
        configJson.add("modSupport", (JsonElement)modSupportJson);
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((JsonElement)configJson, (Appendable)writer);
        }
        catch (IOException e) {
            ConfigJSON.configSaveError(configFile, e);
        }
    }

    public static void loadConfigFromFile() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        File configFile = new File(configDir, "humility-afm.json");
        if (configFile.exists()) {
            Gson gson = new Gson();
            try (FileReader reader = new FileReader(configFile);){
                JsonObject configJson = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                boolean needsUpdating = false;
                if (configJson != null) {
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "transparentCabinetBlocks");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "illuminatedCabinetBlockBrightening");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "enableLightStripBrightening");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "enableLightStripRadiusColorCompensation");
                    needsUpdating |= ConfigJSON.tryLoadViaSetter(configJson, JsonElement::getAsBoolean, "enableCandlestickBeta", Boolean.TYPE);
                    needsUpdating |= ConfigJSON.tryLoadViaSetter(configJson, JsonElement::getAsBoolean, "enableColouredFeatureSetBeta", Boolean.TYPE);
                    needsUpdating |= ConfigJSON.tryLoadEnum(configJson, "creativeItemGroupCategorization", CreativeItemGroupCategorization::valueOf);
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "placeHumilityBlocksInVanillaCreativeCategories");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsFloat, "mosaicsAndTilesStrengthMultiplayer");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsInt, "cabinetBlockBurnTime");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsInt, "cabinetBlockFireSpread");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "datagenMode");
                    needsUpdating |= ConfigJSON.tryLoad(configJson, JsonElement::getAsBoolean, "printInChatServerClientMissmatch");
                    try {
                        JsonObject modSupportJson = configJson.getAsJsonObject("modSupport");
                        for (Map.Entry entry : modSupportJson.entrySet()) {
                            SupportedMods mod = SupportedMods.fromModId((String)entry.getKey());
                            ModSupportState support = ModSupportState.valueOf(((JsonElement)entry.getValue()).getAsString());
                            ModConfig.modSupport.put(mod, support);
                        }
                    }
                    catch (Exception e) {
                        HumilityAFM.LOGGER.error("Failed to load 'modSupport' from config file: {}\nError: {}\nStacktrace: {}\nMarking the config file for update", new Object[]{configFile.getAbsolutePath(), e.getMessage(), e.getStackTrace()});
                        needsUpdating = true;
                    }
                }
                if (needsUpdating) {
                    HumilityAFM.LOGGER.warn("Updating config file to include new values and/or fix broken ones");
                    ConfigJSON.saveConfigToFile();
                }
            }
            catch (IOException e) {
                HumilityAFM.LOGGER.error("Failed to load config file: {}\nError: {}\nStacktrace: {}", new Object[]{configFile.getAbsolutePath(), e.getMessage(), e.getStackTrace()});
            }
        } else {
            ConfigJSON.saveConfigToFile();
        }
    }

    private static <T> boolean tryLoad(JsonObject configJson, Function<JsonElement, T> getter, String fieldName) {
        try {
            T value = getter.apply(configJson.get(fieldName));
            ModConfig.class.getField(fieldName).set(ModConfig.class, value);
        }
        catch (Exception e) {
            ConfigJSON.printLoadError(fieldName, configJson, e);
            return true;
        }
        return false;
    }

    private static <V> boolean tryLoadEnum(JsonObject configJson, String fieldName, Function<String, V> setter) {
        try {
            String value = configJson.get(fieldName).getAsString();
            ModConfig.class.getField(fieldName).set(ModConfig.class, setter.apply(value));
        }
        catch (Exception e) {
            ConfigJSON.printLoadError(fieldName, configJson, e);
            return true;
        }
        return false;
    }

    private static <T> boolean tryLoadViaSetter(JsonObject configJson, Function<JsonElement, T> getter, String fieldName, Class<T> clazz) {
        String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            T value = getter.apply(configJson.get(fieldName));
            ModConfig.class.getMethod(setterName, clazz).invoke(null, value);
        }
        catch (Exception e) {
            ConfigJSON.printLoadError(fieldName, configJson, e);
            return true;
        }
        return false;
    }

    private static void printLoadError(String fieldName, JsonObject configJson, Exception e) {
        HumilityAFM.LOGGER.error("Failed to load '{}' from config file: {}\n\tError: {}\n\tStacktrace: {}", new Object[]{fieldName, configJson, e.getMessage(), e.getStackTrace()});
    }

    protected static void configSaveError(File configFile, IOException e) {
        HumilityAFM.LOGGER.error("Failed to save config file: {}\nError: {}\nStacktrace: {}", new Object[]{configFile.getAbsolutePath(), e.getMessage(), e.getStackTrace()});
    }
}

