/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.generation_data.material_management;

import io.github.mikip98.humilityafm.util.generation_data.material_management.SizedIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class MaterialArrayCombiner
implements SizedIterable<BlockMaterial> {
    private final String[][] arrays;
    private final BlockMaterial.Metadata[] metadataArray;

    public MaterialArrayCombiner(BlockMaterial.Metadata[] metadataArray, String[] ... arrays) {
        if (arrays.length != metadataArray.length) {
            throw new IllegalArgumentException("Number of arrays must match number of metadata entries.");
        }
        this.arrays = arrays;
        this.metadataArray = metadataArray;
    }

    public MaterialArrayCombiner(String[] ... arrays) {
        this.arrays = arrays;
        this.metadataArray = new BlockMaterial.Metadata[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            this.metadataArray[i] = BlockMaterial.Metadata.empty();
        }
    }

    @Override
    @NotNull
    public Iterator<BlockMaterial> iterator() {
        return new MarkedCombinatorIterator();
    }

    @Override
    public void forEach(Consumer<? super BlockMaterial> action) {
        for (BlockMaterial s : this) {
            action.accept(s);
        }
    }

    public <R> Iterable<R> map(final Function<? super BlockMaterial, ? extends R> mapper) {
        return () -> new Iterator<R>(){
            private final Iterator<BlockMaterial> baseIterator;
            {
                this.baseIterator = MaterialArrayCombiner.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIterator.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(this.baseIterator.next());
            }
        };
    }

    @Override
    public int size() {
        int count = 0;
        for (BlockMaterial ignored : this) {
            ++count;
        }
        return count;
    }

    private class MarkedCombinatorIterator
    implements Iterator<BlockMaterial> {
        int outerArrayIndex = 0;
        int outerElementIndex = 0;
        int innerArrayIndex = 0;
        int innerElementIndex = 0;
        BlockMaterial nextValue = null;

        private MarkedCombinatorIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            while (this.outerArrayIndex < MaterialArrayCombiner.this.arrays.length) {
                String outerValue = MaterialArrayCombiner.this.arrays[this.outerArrayIndex][this.outerElementIndex];
                while (this.innerArrayIndex < MaterialArrayCombiner.this.arrays.length) {
                    String innerValue = MaterialArrayCombiner.this.arrays[this.innerArrayIndex][this.innerElementIndex];
                    BlockMaterial.Metadata outerMark = MaterialArrayCombiner.this.metadataArray[this.outerArrayIndex];
                    BlockMaterial.Metadata innerMark = MaterialArrayCombiner.this.metadataArray[this.innerArrayIndex];
                    if (!outerValue.equals(innerValue) || outerMark.sourceMod() != innerMark.sourceMod()) {
                        this.nextValue = BlockMaterial.of(outerValue, outerMark, innerValue, innerMark);
                        this.advanceInnerArrayIndexes();
                        return true;
                    }
                    this.advanceInnerArrayIndexes();
                }
                this.advanceOuterArrayIndexes();
            }
            return false;
        }

        @Override
        public BlockMaterial next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BlockMaterial result = this.nextValue;
            this.nextValue = null;
            return result;
        }

        private void advanceInnerArrayIndexes() {
            ++this.innerElementIndex;
            if (this.innerElementIndex >= MaterialArrayCombiner.this.arrays[this.innerArrayIndex].length) {
                this.innerElementIndex = 0;
                ++this.innerArrayIndex;
            }
        }

        private void advanceOuterArrayIndexes() {
            ++this.outerElementIndex;
            if (this.outerElementIndex >= MaterialArrayCombiner.this.arrays[this.outerArrayIndex].length) {
                this.outerElementIndex = 0;
                ++this.outerArrayIndex;
            }
            this.innerArrayIndex = 0;
            this.innerElementIndex = 0;
        }
    }
}

