/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.simple_iterables;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MultiArrayIterable<T>
implements Iterable<T> {
    private final T[][] arrays;

    @SafeVarargs
    public MultiArrayIterable(T[] ... arrays) {
        this.arrays = arrays;
    }

    @SafeVarargs
    public static <T> MultiArrayIterable<T> of(T[] ... arrays) {
        return new MultiArrayIterable<T>(arrays);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new MultiArrayIterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        T[][] TArray = this.arrays;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] array;
            for (T element : array = TArray[i]) {
                action.accept(element);
            }
        }
    }

    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return Stream.of(this.arrays).flatMap(Stream::of).map(mapper);
    }

    public int size() {
        return Stream.of(this.arrays).mapToInt(array -> ((Object[])array).length).sum();
    }

    private class MultiArrayIterator
    implements Iterator<T> {
        int arrayIndex = 0;
        int elementIndex = 0;

        private MultiArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.arrayIndex < MultiArrayIterable.this.arrays.length && this.elementIndex >= MultiArrayIterable.this.arrays[this.arrayIndex].length) {
                ++this.arrayIndex;
                this.elementIndex = 0;
            }
            return this.arrayIndex < MultiArrayIterable.this.arrays.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return MultiArrayIterable.this.arrays[this.arrayIndex][this.elementIndex++];
        }
    }
}

