/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.generation_data;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.util.Pair;
import io.github.mikip98.humilityafm.util.generation_data.RawGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.LayeredMaterialArrayCombiner;
import io.github.mikip98.humilityafm.util.generation_data.material_management.MaterialArrayCombiner;
import io.github.mikip98.humilityafm.util.generation_data.material_management.MaterialMultiArrayIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.SizedIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockStrength;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.MaterialType;
import io.github.mikip98.humilityafm.util.mod_support.ModSupportManager;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class ActiveGenerationData
extends RawGenerationData {
    protected static Pair<List<String[]>, List<BlockMaterial.Metadata>> activeVanillaWoodTypes = ActiveGenerationData.getGetActiveVanillaWood();
    protected static Pair<List<String[]>, List<BlockMaterial.Metadata>> activeModdedWoodTypes = ActiveGenerationData.getGetActiveModdedWood();
    public static LayeredMaterialArrayCombiner cabinetVariantMaterials = ActiveGenerationData.generateCabinetBlockMaterials();
    public static MaterialMultiArrayIterable forcedCornerStairsVariantMaterials = ActiveGenerationData.generateForcedCornerStairsMaterials();
    public static MaterialArrayCombiner woodenMosaicVariantMaterials = ActiveGenerationData.generateWoodenMosaicMaterials();
    public static LayeredMaterialArrayCombiner terracottaTilesMaterials = new LayeredMaterialArrayCombiner(new List[]{List.of(new String[][]{RawGenerationData.vanillaColorPallet}), List.of(new String[][]{RawGenerationData.vanillaColorPallet})});
    public static MaterialMultiArrayIterable simpleCandlestickMaterials = ActiveGenerationData.generateSimpleCandlestickMaterials();
    public static MaterialMultiArrayIterable[] rustingCandlestickMaterials = ActiveGenerationData.generateRustingCandlestickMaterials();
    public static MaterialMultiArrayIterable colouredFeatureSetMaterials = new MaterialMultiArrayIterable(new String[][]{RawGenerationData.vanillaColorPallet});

    public static void init() {
        int maxAmount = RawGenerationData.allWoodTypes.size() * RawGenerationData.vanillaColorPallet.length;
        ActiveGenerationData.logMaterialCount("Cabinet", cabinetVariantMaterials.size(), maxAmount);
        maxAmount = RawGenerationData.allWoodTypes.size() + RawGenerationData.vanillaStonyMaterials.size();
        ActiveGenerationData.logMaterialCount("Forced corner stairs", forcedCornerStairsVariantMaterials.size(), maxAmount);
        maxAmount = RawGenerationData.allWoodTypes.size() * (RawGenerationData.allWoodTypes.size() - 1);
        ActiveGenerationData.logMaterialCount("Wooden mosaic", woodenMosaicVariantMaterials.size(), maxAmount);
        maxAmount = RawGenerationData.vanillaColorPallet.length * (RawGenerationData.vanillaColorPallet.length - 1);
        ActiveGenerationData.logMaterialCount("Terracotta tiles", terracottaTilesMaterials.size(), maxAmount);
        maxAmount = RawGenerationData.vanillaCandlestickMetals.length;
        ActiveGenerationData.logMaterialCount("Simple candlestick", simpleCandlestickMaterials.size(), maxAmount);
        maxAmount = RawGenerationData.vanillaRustableCandlestickMetals.stream().mapToInt(set -> ((String[])set).length).sum();
        ActiveGenerationData.logMaterialCount("Rusting candlestick", Arrays.stream(rustingCandlestickMaterials).mapToInt(SizedIterable::size).sum(), maxAmount);
        maxAmount = RawGenerationData.vanillaColorPallet.length;
        ActiveGenerationData.logMaterialCount("Coloured feature set", colouredFeatureSetMaterials.size(), maxAmount);
    }

    public static void clear() {
        if (ModConfig.datagenMode) {
            return;
        }
        activeVanillaWoodTypes = null;
        activeModdedWoodTypes = null;
        cabinetVariantMaterials = null;
        forcedCornerStairsVariantMaterials = null;
        woodenMosaicVariantMaterials = null;
        terracottaTilesMaterials = null;
        simpleCandlestickMaterials = null;
        rustingCandlestickMaterials = null;
        colouredFeatureSetMaterials = null;
    }

    protected static LayeredMaterialArrayCombiner generateCabinetBlockMaterials() {
        ArrayList<BlockMaterial.Metadata[]> metadataArrays = new ArrayList<BlockMaterial.Metadata[]>();
        ArrayList woodLayer = new ArrayList();
        ArrayList woodMetadataList = new ArrayList();
        woodLayer.addAll(activeVanillaWoodTypes.left());
        woodMetadataList.addAll(activeVanillaWoodTypes.right());
        woodLayer.addAll(activeModdedWoodTypes.left());
        woodMetadataList.addAll(activeModdedWoodTypes.right());
        metadataArrays.add((BlockMaterial.Metadata[])woodMetadataList.toArray(BlockMaterial.Metadata[]::new));
        ArrayList<String[]> colourLayer = new ArrayList<String[]>();
        colourLayer.add(RawGenerationData.vanillaColorPallet);
        metadataArrays.add(new BlockMaterial.Metadata[]{BlockMaterial.Metadata.empty()});
        List[] layers = new List[]{woodLayer, colourLayer};
        return new LayeredMaterialArrayCombiner((List<BlockMaterial.Metadata[]>)metadataArrays, (List<String[]>[])layers);
    }

    protected static MaterialMultiArrayIterable generateForcedCornerStairsMaterials() {
        ArrayList<String[]> materialSuppliers = new ArrayList<String[]>();
        ArrayList<BlockMaterial.Metadata> materialMetadataList = new ArrayList<BlockMaterial.Metadata>();
        materialSuppliers.addAll((Collection)activeVanillaWoodTypes.left());
        materialMetadataList.addAll((Collection)activeVanillaWoodTypes.right());
        for (Pair<BlockStrength, String[]> material : RawGenerationData.vanillaStonyMaterialsPerStrength) {
            materialSuppliers.add(material.second());
            materialMetadataList.add(BlockMaterial.Metadata.of(MaterialType.STONY, material.first(), null));
        }
        materialSuppliers.addAll((Collection)activeModdedWoodTypes.left());
        materialMetadataList.addAll((Collection)activeModdedWoodTypes.right());
        return MaterialMultiArrayIterable.of((BlockMaterial.Metadata[])materialMetadataList.toArray(BlockMaterial.Metadata[]::new), (String[][])materialSuppliers.toArray(x$0 -> new String[x$0][]));
    }

    protected static MaterialArrayCombiner generateWoodenMosaicMaterials() {
        ArrayList woodenMosaicWoodSuppliers = new ArrayList();
        ArrayList materialMetadataList = new ArrayList();
        woodenMosaicWoodSuppliers.addAll(activeVanillaWoodTypes.left());
        materialMetadataList.addAll(activeVanillaWoodTypes.right());
        woodenMosaicWoodSuppliers.addAll(activeModdedWoodTypes.left());
        materialMetadataList.addAll(activeModdedWoodTypes.right());
        return new MaterialArrayCombiner((BlockMaterial.Metadata[])materialMetadataList.toArray(BlockMaterial.Metadata[]::new), (String[][])woodenMosaicWoodSuppliers.toArray(x$0 -> new String[x$0][]));
    }

    protected static MaterialMultiArrayIterable generateSimpleCandlestickMaterials() {
        return MaterialMultiArrayIterable.of(new BlockMaterial.Metadata[]{BlockMaterial.Metadata.empty()}, new String[][]{RawGenerationData.vanillaCandlestickMetals});
    }

    protected static MaterialMultiArrayIterable[] generateRustingCandlestickMaterials() {
        ArrayList<MaterialMultiArrayIterable> rustingCandlestickMaterialList = new ArrayList<MaterialMultiArrayIterable>();
        for (String[] metalSet : RawGenerationData.vanillaRustableCandlestickMetals) {
            rustingCandlestickMaterialList.add(MaterialMultiArrayIterable.of(new BlockMaterial.Metadata[]{BlockMaterial.Metadata.empty()}, new String[][]{metalSet}));
        }
        return (MaterialMultiArrayIterable[])rustingCandlestickMaterialList.toArray(MaterialMultiArrayIterable[]::new);
    }

    protected static Pair<List<String[]>, List<BlockMaterial.Metadata>> getGetActiveVanillaWood() {
        ArrayList<String[]> vanillaWood = new ArrayList<String[]>();
        ArrayList<BlockMaterial.Metadata> vanillaWoodMetadataList = new ArrayList<BlockMaterial.Metadata>();
        vanillaWood.add(RawGenerationData.vanillaOverworldWoodTypes);
        vanillaWoodMetadataList.add(BlockMaterial.Metadata.of(MaterialType.BURNABLE_WOOD));
        vanillaWood.add(RawGenerationData.vanillaNetherWoodTypes);
        vanillaWoodMetadataList.add(BlockMaterial.Metadata.of(MaterialType.FIREPROOF_WOOD));
        return Pair.of(vanillaWood, vanillaWoodMetadataList);
    }

    protected static Pair<List<String[]>, List<BlockMaterial.Metadata>> getGetActiveModdedWood() {
        String[] moddedWoodTypes;
        SupportedMods mod;
        ArrayList<String[]> activeWoodTypes = new ArrayList<String[]>();
        ArrayList<BlockMaterial.Metadata> activeWoodMetadataList = new ArrayList<BlockMaterial.Metadata>();
        EnumSet<SupportedMods> alreadyAddedMods = EnumSet.noneOf(SupportedMods.class);
        for (Map.Entry<SupportedMods, String[]> modEntry : RawGenerationData.moddedBurnableWoodTypes.entrySet()) {
            mod = modEntry.getKey();
            if (!ModSupportManager.isModLoaded(mod)) continue;
            alreadyAddedMods.add(mod);
            moddedWoodTypes = modEntry.getValue();
            activeWoodTypes.add(moddedWoodTypes);
            activeWoodMetadataList.add(BlockMaterial.Metadata.of(MaterialType.BURNABLE_WOOD, null, mod));
            if (!RawGenerationData.moddedFireProofWoodTypes.containsKey((Object)mod)) continue;
            moddedWoodTypes = RawGenerationData.moddedFireProofWoodTypes.get((Object)mod);
            activeWoodTypes.add(moddedWoodTypes);
            activeWoodMetadataList.add(BlockMaterial.Metadata.of(MaterialType.FIREPROOF_WOOD, null, mod));
        }
        for (Map.Entry<SupportedMods, String[]> modEntry : RawGenerationData.moddedFireProofWoodTypes.entrySet()) {
            mod = modEntry.getKey();
            if (!ModSupportManager.isModLoaded(mod) || alreadyAddedMods.contains((Object)mod)) continue;
            moddedWoodTypes = modEntry.getValue();
            activeWoodTypes.add(moddedWoodTypes);
            activeWoodMetadataList.add(BlockMaterial.Metadata.of(MaterialType.FIREPROOF_WOOD, null, mod));
        }
        return Pair.of(activeWoodTypes, activeWoodMetadataList);
    }

    protected static void logMaterialCount(String title, int activeAmount, int maxAmount) {
        HumilityAFM.LOGGER.info("{} variant materials initialised with {} out of {} materials.", new Object[]{title, activeAmount, maxAmount});
        if (activeAmount > maxAmount) {
            throw new IllegalStateException(title + " variant materials size of '" + activeAmount + "' exceeds the max expected size of '" + maxAmount + "'!");
        }
        if (ModConfig.datagenMode && activeAmount != maxAmount) {
            throw new IllegalStateException(title + " variant materials size does not match the expected size! Expected: " + maxAmount + ", Actual: " + activeAmount + ". Make sure all supported mods are present during datagen.");
        }
    }
}

