/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.datagen;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.content.tags.ModBlockTags;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.MaterialType;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class BlockTagGenerator
extends FabricTagProvider.BlockTagProvider {
    public BlockTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, completableFuture);
    }

    protected void method_10514(class_7225.class_7874 arg) {
        this.generateCabinetTags();
        this.generateWoodenMosaicTags();
        this.getOrCreateTagBuilder(ModBlockTags.TERRACOTTA_TILES_BLOCKS).add((Object[])BlockRegistry.TERRACOTTA_TILE_VARIANTS);
        this.generateForcedCornerStairsTags();
        this.getOrCreateTagBuilder(ModBlockTags.JACK_O_LANTERNS).addTag(ModBlockTags.SPECIAL_JACK_O_LANTERNS).addOptionalTag(ModBlockTags.COLOURED_JACK_O_LANTERNS);
        this.getOrCreateTagBuilder(ModBlockTags.SPECIAL_JACK_O_LANTERNS).add((Object)BlockRegistry.JACK_O_LANTERN_SOUL).add((Object)BlockRegistry.JACK_O_LANTERN_REDSTONE);
        this.getOrCreateTagBuilder(ModBlockTags.COLOURED_JACK_O_LANTERNS).add((Object[])BlockRegistry.COLOURED_JACK_O_LANTERNS);
        FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(ModBlockTags.CANDLESTICKS).add((Object[])BlockRegistry.SIMPLE_CANDLESTICK_FLOOR_VARIANTS).add((Object[])BlockRegistry.SIMPLE_CANDLESTICK_WALL_VARIANTS);
        Arrays.stream(BlockRegistry.RUSTABLE_CANDLESTICK_FLOOR_VARIANTS).forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)tag).add(arg_0));
        Arrays.stream(BlockRegistry.RUSTABLE_CANDLESTICK_WALL_VARIANTS).forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)tag).add(arg_0));
        this.getOrCreateTagBuilder(ModBlockTags.AXE_MINEABLE).addTag(ModBlockTags.CABINET_BLOCKS).addTag(ModBlockTags.ILLUMINATED_CABINET_BLOCKS).addTag(ModBlockTags.WOODEN_MOSAIC_BLOCKS).addTag(ModBlockTags.WOODEN_INNER_STAIRS).addTag(ModBlockTags.WOODEN_OUTER_STAIRS).addTag(ModBlockTags.JACK_O_LANTERNS);
        this.getOrCreateTagBuilder(ModBlockTags.PICKAXE_MINEABLE).addTag(ModBlockTags.TERRACOTTA_TILES_BLOCKS).addTag(ModBlockTags.STONY_INNER_STAIRS).addTag(ModBlockTags.STONY_OUTER_STAIRS).addOptionalTag(ModBlockTags.CANDLESTICKS);
    }

    private void generateCabinetTags() {
        FabricTagProvider.FabricTagBuilder cabinetTag = this.getOrCreateTagBuilder(ModBlockTags.CABINET_BLOCKS);
        FabricTagProvider.FabricTagBuilder illuminatedCabinetTag = this.getOrCreateTagBuilder(ModBlockTags.ILLUMINATED_CABINET_BLOCKS);
        cabinetTag.add((Object)BlockRegistry.CABINET_BLOCK).add((Object)BlockRegistry.FLOOR_CABINET_BLOCK);
        illuminatedCabinetTag.add((Object)BlockRegistry.ILLUMINATED_CABINET_BLOCK).add((Object)BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK);
        String cabinetTagPrefix = "cabinet_blocks_";
        String illuminatedCabinetTagPrefix = "illuminated_cabinet_blocks_";
        HashMap<SupportedMods, class_6862> cabinetTags = new HashMap<SupportedMods, class_6862>();
        HashMap<SupportedMods, class_6862> illuminatedCabinetTags = new HashMap<SupportedMods, class_6862>();
        int i = 0;
        for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
            SupportedMods sourceMod = material.layers()[0].metadata().sourceMod();
            String sourceModId = sourceMod != null ? sourceMod.modId : "vanilla";
            cabinetTags.computeIfAbsent(sourceMod, k -> BlockTagGenerator.getTagKey(cabinetTagPrefix + sourceModId));
            this.getOrCreateTagBuilder((class_6862)cabinetTags.get((Object)sourceMod)).add((Object)BlockRegistry.WALL_CABINET_BLOCK_VARIANTS[i]).add((Object)BlockRegistry.FLOOR_CABINET_BLOCK_VARIANTS[i]);
            illuminatedCabinetTags.computeIfAbsent(sourceMod, k -> BlockTagGenerator.getTagKey(illuminatedCabinetTagPrefix + sourceModId));
            this.getOrCreateTagBuilder((class_6862)illuminatedCabinetTags.get((Object)sourceMod)).add((Object)BlockRegistry.WALL_ILLUMINATED_CABINET_BLOCK_VARIANTS[i]).add((Object)BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK_VARIANTS[i]);
            ++i;
        }
        cabinetTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)cabinetTag).addOptionalTag(arg_0));
        illuminatedCabinetTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)illuminatedCabinetTag).addOptionalTag(arg_0));
    }

    private void generateWoodenMosaicTags() {
        FabricTagProvider.FabricTagBuilder woodenMosaicTag = this.getOrCreateTagBuilder(ModBlockTags.WOODEN_MOSAIC_BLOCKS);
        String woodenMosaicTagPrefix = "wooden_mosaic_blocks_";
        HashMap<HashSet<SupportedMods>, class_6862<class_2248>> woodenMosaicTags = new HashMap<HashSet<SupportedMods>, class_6862<class_2248>>();
        int i = 0;
        for (BlockMaterial material : ActiveGenerationData.woodenMosaicVariantMaterials) {
            SupportedMods layer2SourceMod;
            SupportedMods layer1SourceMod = material.layers()[0].metadata().sourceMod();
            HashSet<SupportedMods> sourceMods = new HashSet<SupportedMods>(Arrays.asList(layer1SourceMod, layer2SourceMod = material.layers()[1].metadata().sourceMod()));
            if (!woodenMosaicTags.containsKey(sourceMods)) {
                String layer1SourceModId = layer1SourceMod != null ? layer1SourceMod.modId : "vanilla";
                String layer2SourceModId = layer2SourceMod != null ? layer2SourceMod.modId : "vanilla";
                woodenMosaicTags.put(sourceMods, BlockTagGenerator.getTagKey(woodenMosaicTagPrefix + layer1SourceModId + "_" + layer2SourceModId));
            }
            this.getOrCreateTagBuilder((class_6862)woodenMosaicTags.get(sourceMods)).add((Object)BlockRegistry.WOODEN_MOSAIC_VARIANTS[i]);
            ++i;
        }
        woodenMosaicTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)woodenMosaicTag).addOptionalTag(arg_0));
    }

    private void generateForcedCornerStairsTags() {
        FabricTagProvider.FabricTagBuilder woodenInnerStairsTag = this.getOrCreateTagBuilder(ModBlockTags.WOODEN_INNER_STAIRS);
        FabricTagProvider.FabricTagBuilder woodenOuterStairsTag = this.getOrCreateTagBuilder(ModBlockTags.WOODEN_OUTER_STAIRS);
        FabricTagProvider.FabricTagBuilder stonyInnerStairsTag = this.getOrCreateTagBuilder(ModBlockTags.STONY_INNER_STAIRS);
        FabricTagProvider.FabricTagBuilder stonyOuterStairsTag = this.getOrCreateTagBuilder(ModBlockTags.STONY_OUTER_STAIRS);
        HashMap<SupportedMods, class_6862> woodenInnerStairsTags = new HashMap<SupportedMods, class_6862>();
        HashMap<SupportedMods, class_6862> woodenOuterStairsTags = new HashMap<SupportedMods, class_6862>();
        HashMap<SupportedMods, class_6862> stonyInnerStairsTags = new HashMap<SupportedMods, class_6862>();
        HashMap<SupportedMods, class_6862> stonyOuterStairsTags = new HashMap<SupportedMods, class_6862>();
        String woodenInnerTagPrefix = "wooden_inner_stairs_";
        String woodenOuterTagPrefix = "wooden_outer_stairs_";
        String stonyInnerTagPrefix = "stony_inner_stairs_";
        String stonyOuterTagPrefix = "stony_outer_stairs_";
        for (BlockMaterial material : ActiveGenerationData.forcedCornerStairsVariantMaterials) {
            if (material.layers().length != 1) {
                throw new IllegalStateException("Forced corner stairs material must have exactly one layer, but found: " + material.layers().length);
            }
            BlockMaterial.Layer layer = material.layers()[0];
            SupportedMods sourceMod = layer.metadata().sourceMod();
            String sourceModId = sourceMod != null ? sourceMod.modId : "vanilla";
            MaterialType type = layer.metadata().type();
            if (type == null) {
                throw new IllegalStateException("Material type for forced corner stairs material must not be null");
            }
            String innerStairsName = "inner_stairs_" + material.getSafeName();
            String outerStairsName = "outer_stairs_" + material.getSafeName();
            switch (type) {
                case BURNABLE_WOOD: 
                case FIREPROOF_WOOD: {
                    String innerTag = "wooden_inner_stairs_" + sourceModId;
                    String outerTag = "wooden_outer_stairs_" + sourceModId;
                    woodenInnerStairsTags.computeIfAbsent(sourceMod, m -> BlockTagGenerator.getTagKey(innerTag));
                    woodenOuterStairsTags.computeIfAbsent(sourceMod, m -> BlockTagGenerator.getTagKey(outerTag));
                    this.getOrCreateTagBuilder((class_6862)woodenInnerStairsTags.get((Object)sourceMod)).add(HumilityAFM.getId(innerStairsName));
                    this.getOrCreateTagBuilder((class_6862)woodenOuterStairsTags.get((Object)sourceMod)).add(HumilityAFM.getId(outerStairsName));
                    break;
                }
                case STONY: {
                    String stonyInnerTag = "stony_inner_stairs_" + sourceModId;
                    String stonyOuterTag = "stony_outer_stairs_" + sourceModId;
                    stonyInnerStairsTags.computeIfAbsent(sourceMod, m -> BlockTagGenerator.getTagKey(stonyInnerTag));
                    stonyOuterStairsTags.computeIfAbsent(sourceMod, m -> BlockTagGenerator.getTagKey(stonyOuterTag));
                    this.getOrCreateTagBuilder((class_6862)stonyInnerStairsTags.get((Object)sourceMod)).add(HumilityAFM.getId(innerStairsName));
                    this.getOrCreateTagBuilder((class_6862)stonyOuterStairsTags.get((Object)sourceMod)).add(HumilityAFM.getId(outerStairsName));
                }
            }
        }
        woodenInnerStairsTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)woodenInnerStairsTag).addOptionalTag(arg_0));
        woodenOuterStairsTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)woodenOuterStairsTag).addOptionalTag(arg_0));
        stonyInnerStairsTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)stonyInnerStairsTag).addOptionalTag(arg_0));
        stonyOuterStairsTags.values().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)stonyOuterStairsTag).addOptionalTag(arg_0));
    }

    public static class_6862<class_2248> getTagKey(String name) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)HumilityAFM.getId(name));
    }
}

