/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.content.blocks.LightStripBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.CabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.FloorCabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.FloorIlluminatedCabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.IlluminatedCabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.candlestick.Candlestick;
import io.github.mikip98.humilityafm.content.blocks.candlestick.FloorCandlestick;
import io.github.mikip98.humilityafm.content.blocks.candlestick.FloorRustableCandlestick;
import io.github.mikip98.humilityafm.content.blocks.candlestick.RustableCandlestick;
import io.github.mikip98.humilityafm.content.blocks.candlestick.logic.RustableCandlestickLogic;
import io.github.mikip98.humilityafm.content.blocks.coloured_torch.ColouredTorch;
import io.github.mikip98.humilityafm.content.blocks.coloured_torch.ColouredWallTorch;
import io.github.mikip98.humilityafm.content.blocks.jack_o_lanterns.ColouredJackOLantern;
import io.github.mikip98.humilityafm.content.blocks.stairs.InnerStairs;
import io.github.mikip98.humilityafm.content.blocks.stairs.OuterStairs;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.RawGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockStrength;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.MaterialType;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2498;
import net.minecraft.class_4970;

public abstract class BlockGeneration {
    protected static CabinetBlockSet generateCabinetBlockSet() {
        FabricBlockSettings fireproofCabinetSettings = CabinetBlock.defaultSettings;
        FabricBlockSettings burnableCabinetSettings = FabricBlockSettings.copyOf((class_4970.class_2251)fireproofCabinetSettings).burnable();
        FabricBlockSettings fireproofIlluminatedCabinetSettings = IlluminatedCabinetBlock.defaultSettings;
        FabricBlockSettings burnableIlluminatedCabinetSettings = FabricBlockSettings.copyOf((class_4970.class_2251)fireproofIlluminatedCabinetSettings).burnable();
        ArrayList<class_2248> wallCabinetVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> floorCabinetVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> wallIlluminatedCabinetVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> floorIlluminatedCabinetVariants = new ArrayList<class_2248>();
        for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
            MaterialType woodMaterialType = material.layers()[0].metadata().type();
            if (woodMaterialType == null) {
                throw new IllegalStateException("Wood material layer for cabinets must have a valid material type");
            }
            boolean fireproof = woodMaterialType.isFireproof;
            FabricBlockSettings normalSettingToUse = fireproof ? fireproofCabinetSettings : burnableCabinetSettings;
            FabricBlockSettings illuminatedSettingToUse = fireproof ? fireproofIlluminatedCabinetSettings : burnableIlluminatedCabinetSettings;
            String name = material.getSafeName();
            class_2248 cabinetBlock = BlockRegistry.register((class_2248)new CabinetBlock((class_4970.class_2251)normalSettingToUse), "wall_cabinet_block_" + name);
            class_2248 floorCabinetBlock = BlockRegistry.register((class_2248)new FloorCabinetBlock((class_4970.class_2251)normalSettingToUse), "cabinet_block_" + name);
            class_2248 illuminatedCabinetBlock = BlockRegistry.register((class_2248)new IlluminatedCabinetBlock((class_4970.class_2251)illuminatedSettingToUse), "wall_illuminated_cabinet_block_" + name);
            class_2248 floorIlluminatedCabinetBlock = BlockRegistry.register((class_2248)new FloorIlluminatedCabinetBlock((class_4970.class_2251)illuminatedSettingToUse), "illuminated_cabinet_block_" + name);
            wallCabinetVariants.add(cabinetBlock);
            floorCabinetVariants.add(floorCabinetBlock);
            wallIlluminatedCabinetVariants.add(illuminatedCabinetBlock);
            floorIlluminatedCabinetVariants.add(floorIlluminatedCabinetBlock);
            if (fireproof) continue;
            BlockRegistry.registerFlammable(cabinetBlock, ModConfig.cabinetBlockBurnTime, ModConfig.cabinetBlockFireSpread);
            BlockRegistry.registerFlammable(floorCabinetBlock, ModConfig.cabinetBlockBurnTime, ModConfig.cabinetBlockFireSpread);
            BlockRegistry.registerFlammable(illuminatedCabinetBlock, ModConfig.cabinetBlockBurnTime, ModConfig.cabinetBlockFireSpread);
            BlockRegistry.registerFlammable(floorIlluminatedCabinetBlock, ModConfig.cabinetBlockBurnTime, ModConfig.cabinetBlockFireSpread);
        }
        return new CabinetBlockSet((class_2248[])wallCabinetVariants.toArray(class_2248[]::new), (class_2248[])floorCabinetVariants.toArray(class_2248[]::new), (class_2248[])wallIlluminatedCabinetVariants.toArray(class_2248[]::new), (class_2248[])floorIlluminatedCabinetVariants.toArray(class_2248[]::new));
    }

    protected static ForcedCornerStairsBlockSet generateForcedCornerStairsBlockSet() {
        FabricBlockSettings woodStairsBlockSettings = FabricBlockSettings.create().strength(RawGenerationData.vanillaWoodHardness, RawGenerationData.vanillaWoodResistance).requiresTool().sounds(class_2498.field_11547);
        FabricBlockSettings burnableWoodStairsBlockSettings = FabricBlockSettings.copyOf((class_4970.class_2251)woodStairsBlockSettings).burnable();
        BiFunction<Float, Float, FabricBlockSettings> stonyStairsBlockSettingsGenerator = (hardness, resistance) -> FabricBlockSettings.create().strength(hardness.floatValue(), resistance.floatValue()).requiresTool().sounds(class_2498.field_11544);
        ArrayList<class_2248> innerStairs = new ArrayList<class_2248>();
        ArrayList<class_2248> outerStairs = new ArrayList<class_2248>();
        for (BlockMaterial variantMaterial : ActiveGenerationData.forcedCornerStairsVariantMaterials) {
            if (variantMaterial.layers().length != 1) {
                throw new IllegalStateException("Forced Corner Stairs Variant material must have exactly one layer");
            }
            BlockMaterial.Layer variant = variantMaterial.layers()[0];
            BlockMaterial.Metadata materialMetadata = variant.metadata();
            MaterialType materialType = materialMetadata.type();
            if (materialType == null) {
                throw new IllegalStateException("Material type cannot be null for variant: " + variant.name());
            }
            Object variantName = variant.name();
            FabricBlockSettings settingsToUse = switch (materialType) {
                case MaterialType.BURNABLE_WOOD -> burnableWoodStairsBlockSettings;
                case MaterialType.FIREPROOF_WOOD -> woodStairsBlockSettings;
                case MaterialType.STONY -> {
                    BlockStrength blockStrength = materialMetadata.blockStrength();
                    if (blockStrength == null) {
                        throw new IllegalStateException("Block strength cannot be null for stony material: " + variant.name());
                    }
                    yield stonyStairsBlockSettingsGenerator.apply(Float.valueOf(blockStrength.hardness()), Float.valueOf(blockStrength.resistance()));
                }
                default -> throw new IllegalStateException("Unsupported material type: " + String.valueOf((Object)materialType));
            };
            SupportedMods sourceMod = materialMetadata.sourceMod();
            if (sourceMod != null) {
                variantName = sourceMod.modId + "_" + (String)variantName;
            }
            innerStairs.add(BlockRegistry.registerWithItem((class_2248)new InnerStairs((class_4970.class_2251)settingsToUse), "inner_stairs_" + (String)variantName));
            outerStairs.add(BlockRegistry.registerWithItem((class_2248)new OuterStairs((class_4970.class_2251)woodStairsBlockSettings), "outer_stairs_" + (String)variantName));
        }
        return new ForcedCornerStairsBlockSet((class_2248[])innerStairs.toArray(class_2248[]::new), (class_2248[])outerStairs.toArray(class_2248[]::new));
    }

    protected static class_2248[] generateWoodenMosaicVariants() {
        FabricBlockSettings fireproofWoodenMosaicSettings = FabricBlockSettings.create().strength(RawGenerationData.vanillaWoodHardness * ModConfig.mosaicsAndTilesStrengthMultiplayer, RawGenerationData.vanillaWoodResistance * ModConfig.mosaicsAndTilesStrengthMultiplayer).sounds(class_2498.field_11547).requiresTool();
        FabricBlockSettings burnableWoodenMosaicSettings = FabricBlockSettings.copyOf((class_4970.class_2251)fireproofWoodenMosaicSettings).burnable();
        byte burn = (byte)Math.round(5.0f * ModConfig.mosaicsAndTilesStrengthMultiplayer);
        byte spread = (byte)Math.round(20.0f / ModConfig.mosaicsAndTilesStrengthMultiplayer);
        ArrayList<class_2248> woodenMosaicVariants = new ArrayList<class_2248>();
        for (BlockMaterial variantMaterial : ActiveGenerationData.woodenMosaicVariantMaterials) {
            class_2248 block;
            boolean isSecondWoodFireproof;
            if (variantMaterial.layers().length != 2) {
                throw new IllegalStateException("Wooden Mosaic Variant material must have exactly two layers");
            }
            String variantName = variantMaterial.getSafeName();
            boolean isFirstWoodFireproof = variantMaterial.layers()[0].metadata().type() == MaterialType.FIREPROOF_WOOD;
            boolean bl = isSecondWoodFireproof = variantMaterial.layers()[1].metadata().type() == MaterialType.FIREPROOF_WOOD;
            if (isFirstWoodFireproof && isSecondWoodFireproof) {
                block = BlockRegistry.registerWithItem(new class_2248((class_4970.class_2251)fireproofWoodenMosaicSettings), "wooden_mosaic_" + variantName);
            } else {
                block = BlockRegistry.registerWithItem(new class_2248((class_4970.class_2251)burnableWoodenMosaicSettings), "wooden_mosaic_" + variantName);
                if (isFirstWoodFireproof || isSecondWoodFireproof) {
                    BlockRegistry.registerFlammable(block, burn * 4, spread / 4);
                } else {
                    BlockRegistry.registerFlammable(block, burn, spread);
                }
            }
            woodenMosaicVariants.add(block);
        }
        return (class_2248[])woodenMosaicVariants.toArray(class_2248[]::new);
    }

    protected static class_2248[] generateTerracottaTilesVariants() {
        FabricBlockSettings terracottaTilesSettings = FabricBlockSettings.create().strength(RawGenerationData.vanillaTerracottaHardness * ModConfig.mosaicsAndTilesStrengthMultiplayer, RawGenerationData.vanillaTerracottaResistance * ModConfig.mosaicsAndTilesStrengthMultiplayer).requiresTool();
        ArrayList<class_2248> terracottaTilesVariants = new ArrayList<class_2248>();
        for (BlockMaterial material : ActiveGenerationData.terracottaTilesMaterials) {
            terracottaTilesVariants.add(BlockRegistry.registerWithItem(new class_2248((class_4970.class_2251)terracottaTilesSettings), "terracotta_tiles_" + material.getSafeName()));
        }
        return (class_2248[])terracottaTilesVariants.toArray(class_2248[]::new);
    }

    protected static CandlestickBlockSet generateCandlestickBlockSet() {
        if (!ModConfig.getEnableCandlestickBeta()) {
            return new CandlestickBlockSet(null, null, null, null);
        }
        ArrayList<class_2248> simpleCandlestickWallVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> simpleCandlestickFloorVariants = new ArrayList<class_2248>();
        for (BlockMaterial material : ActiveGenerationData.simpleCandlestickMaterials) {
            simpleCandlestickWallVariants.add(BlockRegistry.register((class_2248)new Candlestick(), "candlestick_wall_" + material.getSafeName()));
            simpleCandlestickFloorVariants.add(BlockRegistry.register(new FloorCandlestick(), "candlestick_" + material.getSafeName()));
        }
        int metalSetCount = ActiveGenerationData.rustingCandlestickMaterials.length;
        RustableCandlestick[][] rustableCandlestickWallVariants = new RustableCandlestick[metalSetCount][];
        class_2248[][] rustableCandlestickFloorVariants = new FloorRustableCandlestick[metalSetCount][];
        for (int i = 0; i < metalSetCount; ++i) {
            ArrayList<RustableCandlestick> metalSetWallVaraintList = new ArrayList<RustableCandlestick>();
            ArrayList<FloorRustableCandlestick> metalSetFloorVariantList = new ArrayList<FloorRustableCandlestick>();
            for (BlockMaterial material : ActiveGenerationData.rustingCandlestickMaterials[i]) {
                metalSetWallVaraintList.add((RustableCandlestick)BlockRegistry.register((class_2248)new RustableCandlestick(), "candlestick_wall_" + material.getSafeName()));
                metalSetFloorVariantList.add((FloorRustableCandlestick)BlockRegistry.register(new FloorRustableCandlestick(), "candlestick_" + material.getSafeName()));
            }
            rustableCandlestickWallVariants[i] = (RustableCandlestick[])metalSetWallVaraintList.toArray(RustableCandlestick[]::new);
            rustableCandlestickFloorVariants[i] = (FloorRustableCandlestick[])metalSetFloorVariantList.toArray(FloorRustableCandlestick[]::new);
            BlockGeneration.fillRustStages(rustableCandlestickWallVariants[i]);
            BlockGeneration.fillRustStages((RustableCandlestickLogic[])rustableCandlestickFloorVariants[i]);
        }
        return new CandlestickBlockSet((class_2248[])simpleCandlestickWallVariants.toArray(class_2248[]::new), (class_2248[])simpleCandlestickFloorVariants.toArray(class_2248[]::new), (class_2248[][])rustableCandlestickWallVariants, rustableCandlestickFloorVariants);
    }

    protected static void fillRustStages(RustableCandlestickLogic[] candlestickMetalSet) {
        int length = candlestickMetalSet.length;
        if (length >= 2) {
            candlestickMetalSet[0].setRustNextLevel(((class_2248)candlestickMetalSet[1]).method_9564());
            for (int i = 1; i < length - 1; ++i) {
                candlestickMetalSet[i].setRustPreviousLevel(((class_2248)candlestickMetalSet[i - 1]).method_9564());
                candlestickMetalSet[i].setRustNextLevel(((class_2248)candlestickMetalSet[i + 1]).method_9564());
            }
            candlestickMetalSet[length - 1].setRustPreviousLevel(((class_2248)candlestickMetalSet[length - 2]).method_9564());
        }
    }

    protected static ColouredFeatureBlockSet generateColouredFeatureBlockSet() {
        if (!ModConfig.getEnableColouredFeatureSetBeta()) {
            return new ColouredFeatureBlockSet(null, null, null, null);
        }
        class_2400 torchParticle = class_2398.field_11240;
        ArrayList<class_2248> lightStripVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> colouredTorchVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> colouredWallTorchVariants = new ArrayList<class_2248>();
        ArrayList<class_2248> colouredJackOLanterns = new ArrayList<class_2248>();
        for (BlockMaterial material : ActiveGenerationData.colouredFeatureSetMaterials) {
            String name = material.getSafeName();
            lightStripVariants.add(BlockRegistry.registerWithItem((class_2248)new LightStripBlock(), "light_strip_" + name));
            colouredTorchVariants.add(BlockRegistry.register((class_2248)new ColouredTorch((class_2394)torchParticle), "coloured_torch_" + name));
            colouredWallTorchVariants.add(BlockRegistry.register((class_2248)new ColouredWallTorch((class_2394)torchParticle), "coloured_wall_torch_" + name));
            colouredJackOLanterns.add(BlockRegistry.registerWithItem((class_2248)new ColouredJackOLantern(), "coloured_jack_o_lantern_" + name));
        }
        return new ColouredFeatureBlockSet((class_2248[])lightStripVariants.toArray(class_2248[]::new), (class_2248[])colouredTorchVariants.toArray(class_2248[]::new), (class_2248[])colouredWallTorchVariants.toArray(class_2248[]::new), (class_2248[])colouredJackOLanterns.toArray(class_2248[]::new));
    }

    protected record CabinetBlockSet(class_2248[] wallCabinets, class_2248[] floorCabinets, class_2248[] wallIlluminatedCabinets, class_2248[] floorIlluminatedCabinets) {
    }

    protected record ForcedCornerStairsBlockSet(class_2248[] innerStairs, class_2248[] outerStairs) {
    }

    protected record CandlestickBlockSet(class_2248[] simpleCandlestickWallVariants, class_2248[] simpleCandlestickFloorVariants, class_2248[][] rustableCandlestickWallVariants, class_2248[][] rustableCandlestickFloorVariants) {
    }

    protected record ColouredFeatureBlockSet(class_2248[] lightStripVariants, class_2248[] colouredTorchVariants, class_2248[] colouredWallTorchVariants, class_2248[] colouredJackOLanternVariants) {
    }
}

