/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.simple_iterables;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class MultiIterableIterable<T>
implements Iterable<T> {
    private final List<Iterable<T>> iterableList;

    @SafeVarargs
    public MultiIterableIterable(Iterable<T> ... iterables) {
        this.iterableList = List.of(iterables);
    }

    @SafeVarargs
    public static <T> MultiIterableIterable<T> of(Iterable<T> ... iterables) {
        return new MultiIterableIterable<T>(iterables);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new CompositeIterator();
    }

    public int size() {
        return this.iterableList.stream().mapToInt(iterable -> {
            int size = 0;
            for (Object ignored : iterable) {
                ++size;
            }
            return size;
        }).sum();
    }

    private class CompositeIterator
    implements Iterator<T> {
        private final Iterator<Iterable<T>> outerIterator;
        private Iterator<T> current;

        private CompositeIterator() {
            this.outerIterator = MultiIterableIterable.this.iterableList.iterator();
            this.current = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && this.outerIterator.hasNext()) {
                this.current = this.outerIterator.next().iterator();
            }
            return this.current.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }
    }
}

