/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.util.generation_data.material_management.material;

import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockStrength;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.MaterialType;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockMaterial(@NotNull Layer[] layers) {
    public static BlockMaterial of(Layer ... layers) {
        return new BlockMaterial(layers);
    }

    public static BlockMaterial of(@NotNull Layer layer) {
        return new BlockMaterial(new Layer[]{layer});
    }

    public static BlockMaterial of(@NotNull String name, @NotNull Metadata metadata) {
        return new BlockMaterial(new Layer[]{new Layer(name, metadata)});
    }

    public static BlockMaterial of(@NotNull String name1, @NotNull Metadata metadata1, @NotNull String name2, @NotNull Metadata metadata2) {
        return new BlockMaterial(new Layer[]{new Layer(name1, metadata1), new Layer(name2, metadata2)});
    }

    public String getRawName() {
        return String.join((CharSequence)"_", (CharSequence[])Arrays.stream(this.layers).map(Layer::name).toArray(String[]::new));
    }

    public String getSafeName() {
        return String.join((CharSequence)"_", (CharSequence[])Arrays.stream(this.layers).map(layer -> layer.metadata.sourceMod() != null ? layer.metadata.sourceMod().modId + "_" + layer.name : layer.name).toArray(String[]::new));
    }

    public record Layer(String name, Metadata metadata) {
    }

    public record Metadata(@Nullable MaterialType type, @Nullable BlockStrength blockStrength, @Nullable SupportedMods sourceMod) {
        public static Metadata of(@Nullable MaterialType type, @Nullable BlockStrength blockStrength, @Nullable SupportedMods sourceMod) {
            return new Metadata(type, blockStrength, sourceMod);
        }

        public static Metadata of(@Nullable MaterialType type, @Nullable BlockStrength blockStrength) {
            return new Metadata(type, blockStrength, null);
        }

        public static Metadata of(@Nullable MaterialType type, @Nullable SupportedMods sourceMod) {
            return new Metadata(type, null, sourceMod);
        }

        public static Metadata of(@Nullable BlockStrength blockStrength, @Nullable SupportedMods sourceMod) {
            return new Metadata(null, blockStrength, sourceMod);
        }

        public static Metadata of(@Nullable MaterialType type) {
            return new Metadata(type, null, null);
        }

        public static Metadata of(@Nullable BlockStrength blockStrength) {
            return new Metadata(null, blockStrength, null);
        }

        public static Metadata of(@Nullable SupportedMods sourceMod) {
            return new Metadata(null, null, sourceMod);
        }

        public static Metadata empty() {
            return new Metadata(null, null, null);
        }
    }
}

