/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamwizardry.librarianlib.core.util.ModLogManager;
import dev.thecodewarrior.hooked.Hooked;
import dev.thecodewarrior.hooked.shade.obj.FloatTuple;
import dev.thecodewarrior.hooked.shade.obj.Obj;
import dev.thecodewarrior.hooked.shade.obj.ObjData;
import dev.thecodewarrior.hooked.shade.obj.ObjReader;
import dev.thecodewarrior.hooked.shade.obj.ObjUtils;
import dev.thecodewarrior.hooked.shade.obj.Objs;
import dev.thecodewarrior.hooked.shade.obj.ReadableObj;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Ldev/thecodewarrior/hooked/client/renderer/HookModelRenderer;", "", "Lnet/minecraft/resources/ResourceLocation;", "modelLocation", "<init>", "(Lnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/server/packs/resources/ResourceManager;", "manager", "", "loadModel", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "consumer", "", "lightmap", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;I)V", "Lnet/minecraft/resources/ResourceLocation;", "getModelLocation", "()Lnet/minecraft/resources/ResourceLocation;", "Ldev/thecodewarrior/hooked/shade/obj/Obj;", "model", "Ldev/thecodewarrior/hooked/shade/obj/Obj;", "", "modelVertexIndices", "[I", "Companion", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nHookModelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HookModelLoader.kt\ndev/thecodewarrior/hooked/client/renderer/HookModelRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ClientUtils.kt\ndev/thecodewarrior/hooked/util/ClientUtilsKt\n+ 5 ModLogManager.kt\ncom/teamwizardry/librarianlib/core/util/ModLogManager\n*L\n1#1,91:1\n1#2:92\n13504#3,2:93\n13506#3:99\n9#4:95\n18#4:96\n9#4:97\n18#4:98\n58#5:100\n*S KotlinDebug\n*F\n+ 1 HookModelLoader.kt\ndev/thecodewarrior/hooked/client/renderer/HookModelRenderer\n*L\n69#1:93,2\n69#1:99\n73#1:95\n74#1:96\n81#1:97\n82#1:98\n89#1:100\n*E\n"})
public final class HookModelRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation modelLocation;
    @NotNull
    private Obj model;
    @NotNull
    private int[] modelVertexIndices;
    @NotNull
    private static final Logger logger;

    public HookModelRenderer(@NotNull ResourceLocation modelLocation) {
        Intrinsics.checkNotNullParameter((Object)modelLocation, (String)"modelLocation");
        this.modelLocation = modelLocation;
        Obj obj = Objs.create();
        Intrinsics.checkNotNullExpressionValue((Object)obj, (String)"create(...)");
        this.model = obj;
        this.modelVertexIndices = new int[0];
    }

    @NotNull
    public final ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadModel(@NotNull ResourceManager manager) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        try {
            Obj obj;
            object = manager.open(this.modelLocation);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                obj = ObjReader.read(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = obj;
        }
        catch (IOException e) {
            logger.error("Failed to load model", (Throwable)e);
            object = Objs.create();
        }
        Object rawModel = object;
        this.model = ObjUtils.convertToRenderable((ReadableObj)rawModel);
        this.modelVertexIndices = ObjData.getFaceVertexIndicesArray(this.model);
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull PoseStack matrices, @NotNull VertexConsumer consumer, int lightmap) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        int[] $this$forEachIndexed$iv = this.modelVertexIndices;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int item$iv : $this$forEachIndexed$iv) {
            void $this$vertex$iv;
            float y$iv;
            void x$iv22;
            VertexConsumer $this$normal$iv;
            void y$iv2;
            float x$iv;
            void $this$vertex$iv22;
            void vertexIndex;
            int n = index$iv++;
            int n2 = item$iv;
            int i = n;
            boolean bl = false;
            FloatTuple vertex = this.model.getVertex((int)vertexIndex);
            FloatTuple tex = this.model.getTexCoord((int)vertexIndex);
            FloatTuple normal = this.model.getNormal((int)vertexIndex);
            VertexConsumer vertexConsumer = consumer;
            float f = vertex.getX();
            float f2 = vertex.getY();
            float z$iv = vertex.getZ();
            boolean $i$f$vertex = false;
            VertexConsumer vertexConsumer2 = $this$vertex$iv22.addVertex(matrices.last(), x$iv, (float)y$iv2, z$iv);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer2, (String)"vertex(...)");
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer2.setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(tex.getX(), 1.0f - tex.getY()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightmap), (String)"light(...)");
            float $this$vertex$iv22 = normal.getX();
            x$iv = normal.getY();
            float z$iv2 = normal.getZ();
            boolean $i$f$normal = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$normal$iv.setNormal(matrices.last(), (float)x$iv22, y$iv, z$iv2), (String)"normal(...)");
            if (i % 3 != 2) continue;
            VertexConsumer x$iv22 = consumer;
            y$iv = vertex.getX();
            z$iv2 = vertex.getY();
            z$iv = vertex.getZ();
            $i$f$vertex = false;
            VertexConsumer vertexConsumer3 = $this$vertex$iv.addVertex(matrices.last(), x$iv, (float)y$iv2, z$iv);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer3, (String)"vertex(...)");
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer3.setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(tex.getX(), 1.0f - tex.getY()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightmap), (String)"light(...)");
            $this$vertex$iv22 = normal.getX();
            x$iv = normal.getY();
            z$iv2 = normal.getZ();
            $i$f$normal = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$normal$iv.setNormal(matrices.last(), (float)x$iv22, y$iv, z$iv2), (String)"normal(...)");
        }
    }

    static {
        ModLogManager this_$iv = Hooked.INSTANCE.getLogManager();
        boolean $i$f$makeLogger = false;
        logger = this_$iv.makeLogger(HookModelRenderer.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/thecodewarrior/hooked/client/renderer/HookModelRenderer$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "hooked-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

