/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.hook;

import com.teamwizardry.librarianlib.core.util.ModLogManager;
import com.teamwizardry.librarianlib.core.util.Shorthand;
import com.teamwizardry.librarianlib.etcetera.Raycaster;
import com.teamwizardry.librarianlib.math.Vec3dKt;
import dev.thecodewarrior.hooked.HookGameRules;
import dev.thecodewarrior.hooked.Hooked;
import dev.thecodewarrior.hooked.capability.HookedPlayerData;
import dev.thecodewarrior.hooked.hook.Hook;
import dev.thecodewarrior.hooked.hook.HookControllerDelegate;
import dev.thecodewarrior.hooked.hook.HookEvent;
import dev.thecodewarrior.hooked.hook.HookPlayerController;
import dev.thecodewarrior.hooked.hook.HookProcessor;
import dev.thecodewarrior.hooked.hook.HookProcessorContext;
import dev.thecodewarrior.hooked.util.MiscUtilsKt;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\bJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bR\u001a\u0010\u0010\u001a\u00020\u000f8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/thecodewarrior/hooked/hook/CommonHookProcessor;", "Ldev/thecodewarrior/hooked/hook/HookProcessor;", "<init>", "()V", "Ldev/thecodewarrior/hooked/hook/HookProcessorContext;", "context", "", "applyHookMotion", "(Ldev/thecodewarrior/hooked/hook/HookProcessorContext;)V", "removeNaN", "updateHooks", "updateExtending", "updatePlanted", "updateRetracting", "removeAbsurdLength", "Lcom/teamwizardry/librarianlib/etcetera/Raycaster;", "raycaster", "Lcom/teamwizardry/librarianlib/etcetera/Raycaster;", "getRaycaster", "()Lcom/teamwizardry/librarianlib/etcetera/Raycaster;", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nCommonHookProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonHookProcessor.kt\ndev/thecodewarrior/hooked/hook/CommonHookProcessor\n+ 2 ModLogManager.kt\ncom/teamwizardry/librarianlib/core/util/ModLogManager\n*L\n1#1,207:1\n58#2:208\n*S KotlinDebug\n*F\n+ 1 CommonHookProcessor.kt\ndev/thecodewarrior/hooked/hook/CommonHookProcessor\n*L\n206#1:208\n*E\n"})
public abstract class CommonHookProcessor
implements HookProcessor {
    @NotNull
    private final Raycaster raycaster = new Raycaster();
    @NotNull
    private final Logger logger;

    public CommonHookProcessor() {
        ModLogManager this_$iv = Hooked.INSTANCE.getLogManager();
        boolean $i$f$makeLogger = false;
        this.logger = this_$iv.makeLogger(CommonHookProcessor.class);
    }

    @NotNull
    protected final Raycaster getRaycaster() {
        return this.raycaster;
    }

    protected final void applyHookMotion(@NotNull HookProcessorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.removeNaN(context);
        this.removeAbsurdLength(context);
        this.updateHooks(context);
    }

    private final void removeNaN(HookProcessorContext context) {
        Iterator iter;
        Iterator iterator2 = iter = ((Map)context.getData().getHooks()).entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            Integer id = (Integer)entry.getKey();
            Hook hook = (Hook)entry.getValue();
            double d = hook.getPos().x;
            if (!Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = hook.getPos().y) && !Double.isNaN(d) && !Double.isInfinite(d = hook.getPos().z) && !Double.isNaN(d)) continue;
            hook.setState(Hook.State.REMOVED);
            HookedPlayerData.SyncStatus syncStatus = context.getData().getSyncStatus();
            Intrinsics.checkNotNull((Object)hook);
            syncStatus.addRecentHook(hook);
            iter.remove();
            this.logger.error("Removing hook " + hook + " that had an infinite or NaN position from player " + context.getPlayer().getName());
            HookControllerDelegate.syncHook$default(context, hook, false, false, false, 14, null);
        }
    }

    private final void updateHooks(HookProcessorContext context) {
        for (Hook hook : context.getHooks()) {
            hook.setPosLastTick(hook.getPos());
            hook.setFirstTick(false);
        }
        this.updateRetracting(context);
        this.updateExtending(context);
        this.updatePlanted(context);
    }

    private final void updateExtending(HookProcessorContext context) {
        for (Hook hook : context.getHooks()) {
            if (hook.getState() != Hook.State.EXTENDING) continue;
            double distanceLeft = context.getController().modifyHookRange(context.getProperties().getRange(), hook) - Vec3dKt.minus((Vec3)hook.getPos(), (Vec3)MiscUtilsKt.getWaistPos(context.getPlayer())).length();
            double castDistance = Math.min(context.getProperties().getSpeed(), distanceLeft) + (double)context.getProperties().getHookModel().getHookLength();
            Raycaster.RaycastRequest request = new Raycaster.RaycastRequest(context.getWorld(), hook.getPos().x, hook.getPos().y, hook.getPos().z, hook.getPos().x + hook.getDirection().x * castDistance, hook.getPos().y + hook.getDirection().y * castDistance, hook.getPos().z + hook.getDirection().z * castDistance).withEntityContext((Entity)context.getPlayer());
            context.getController().configureRaycast(request);
            this.raycaster.cast(request);
            hook.setPos(Vec3dKt.plus((Vec3)hook.getPos(), (Vec3)Vec3dKt.times((Vec3)hook.getDirection(), (double)(castDistance * this.raycaster.getFraction() - (double)hook.getHookLength()))));
            if (WhenMappings.$EnumSwitchMapping$0[this.raycaster.getHitType().ordinal()] == 1) {
                hook.setState(Hook.State.PLANTED);
                hook.setBlock(Shorthand.block((int)this.raycaster.getBlockX(), (int)this.raycaster.getBlockY(), (int)this.raycaster.getBlockZ()));
                HookControllerDelegate.syncHook$default(context, hook, false, false, false, 10, null);
                context.fireEvent(new HookEvent(HookEvent.EventType.HIT, hook.getId(), 0));
            } else if (distanceLeft <= context.getProperties().getSpeed()) {
                hook.setState(Hook.State.RETRACTING);
                HookControllerDelegate.syncHook$default(context, hook, false, false, false, 10, null);
                context.fireEvent(new HookEvent(HookEvent.EventType.MISS, hook.getId(), 0));
            }
            this.raycaster.reset();
        }
    }

    private final void updatePlanted(HookProcessorContext context) {
        if (!context.isSelfClient()) {
            return;
        }
        if (context.getPlayer().isFallFlying() && !context.getPlayer().level().getGameRules().getBoolean(HookGameRules.ALLOW_HOOKS_WHILE_FLYING)) {
            for (Hook hook : context.getHooks()) {
                if (hook.getState() == Hook.State.RETRACTING) continue;
                hook.setState(Hook.State.RETRACTING);
                HookControllerDelegate.syncHook$default(context, hook, false, false, false, 14, null);
                context.fireEvent(new HookEvent(HookEvent.EventType.DISLODGE, hook.getId(), HookPlayerController.DislodgeReason.DISALLOWED.ordinal()));
            }
        }
        double breakEpsilon = 0.0625;
        for (Hook hook : context.getHooks()) {
            HookPlayerController.DislodgeReason dislodgeReason;
            if (hook.getState() != Hook.State.PLANTED) continue;
            double hookRange = context.getController().modifyHookRange(context.getProperties().getRange(), hook) + breakEpsilon;
            if (hook.getPos().distanceTo(MiscUtilsKt.getWaistPos(context.getPlayer())) > hookRange) {
                dislodgeReason = HookPlayerController.DislodgeReason.DISTANCE;
            } else {
                if (!context.getWorld().isEmptyBlock(hook.getBlock())) continue;
                dislodgeReason = HookPlayerController.DislodgeReason.BLOCK_BROKEN;
            }
            HookPlayerController.DislodgeReason reason = dislodgeReason;
            hook.setState(Hook.State.RETRACTING);
            HookControllerDelegate.syncHook$default(context, hook, false, false, false, 14, null);
            context.fireEvent(new HookEvent(HookEvent.EventType.DISLODGE, hook.getId(), reason.ordinal()));
        }
        int plantedCount = 0;
        NavigableMap<Integer, Hook> navigableMap = context.getData().getHooks().descendingMap();
        Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"descendingMap(...)");
        Iterator iterator2 = ((Map)navigableMap).entrySet().iterator();
        while (iterator2.hasNext()) {
            Hook hook = (Hook)iterator2.next().getValue();
            if (hook.getState() != Hook.State.PLANTED || ++plantedCount <= context.getProperties().getCount()) continue;
            hook.setState(Hook.State.RETRACTING);
            HookControllerDelegate hookControllerDelegate = context;
            Intrinsics.checkNotNull((Object)hook);
            HookControllerDelegate.syncHook$default(hookControllerDelegate, hook, false, false, false, 14, null);
            context.fireEvent(new HookEvent(HookEvent.EventType.DISLODGE, hook.getId(), HookPlayerController.DislodgeReason.HOOK_COUNT.ordinal()));
        }
    }

    private final void updateRetracting(HookProcessorContext context) {
        Iterator iterator2;
        Iterator iterator3 = iterator2 = ((Map)context.getData().getHooks()).entrySet().iterator();
        while (iterator3.hasNext()) {
            Hook hook = (Hook)iterator3.next().getValue();
            if (hook.getState() != Hook.State.RETRACTING) continue;
            Vec3 delta = Vec3dKt.minus((Vec3)hook.getPos(), (Vec3)MiscUtilsKt.getWaistPos(context.getPlayer()));
            double distance = delta.length();
            if (distance < Math.max(context.getProperties().getSpeed(), 1.0)) {
                HookedPlayerData.SyncStatus syncStatus = context.getData().getSyncStatus();
                Intrinsics.checkNotNull((Object)hook);
                syncStatus.addRecentHook(hook);
                iterator2.remove();
                hook.setState(Hook.State.REMOVED);
                HookControllerDelegate.syncHook$default(context, hook, false, false, false, 8, null);
                continue;
            }
            Vec3 direction = Vec3dKt.div((Vec3)delta, (double)distance);
            hook.setPos(Vec3dKt.minus((Vec3)hook.getPos(), (Vec3)Vec3dKt.times((Vec3)direction, (double)Math.min(context.getProperties().getSpeed(), distance))));
            hook.setYaw(-((float)Math.toDegrees(Math.atan2(direction.x, direction.z))));
            hook.setPitch(-((float)Math.toDegrees(Math.asin(direction.y))));
        }
    }

    private final void removeAbsurdLength(HookProcessorContext context) {
        Iterator iter;
        Vec3 waist = MiscUtilsKt.getWaistPos(context.getPlayer());
        Iterator iterator2 = iter = ((Map)context.getData().getHooks()).entrySet().iterator();
        while (iterator2.hasNext()) {
            Hook hook = (Hook)iterator2.next().getValue();
            double distance = waist.distanceTo(hook.getPos());
            if (!(distance > 10000.0)) continue;
            this.logger.warn("Hook was an absurd distance (" + distance + ") from player. Removing " + hook + " from " + context.getPlayer().getName());
            HookedPlayerData.SyncStatus syncStatus = context.getData().getSyncStatus();
            Intrinsics.checkNotNull((Object)hook);
            syncStatus.addRecentHook(hook);
            iter.remove();
            hook.setState(Hook.State.REMOVED);
            HookControllerDelegate.syncHook$default(context, hook, false, false, false, 14, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Raycaster.HitType.values().length];
            try {
                nArray[Raycaster.HitType.BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

