/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.mixin;

import dev.thecodewarrior.hooked.bridge.PlayerMixinBridge;
import dev.thecodewarrior.hooked.hook.HookActiveReason;
import dev.thecodewarrior.hooked.hook.HookProcessor;
import dev.thecodewarrior.hooked.hook.NullHookProcessor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerMixinBridge {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tryToStartFallFlying()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hooked$checkFallFlyingMixin(CallbackInfoReturnable<Boolean> cir) {
        if (this.isHookActive(HookActiveReason.CANCEL_ELYTRA)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hooked$isInvulnerableToMixin(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (damageSource.is(DamageTypes.FLY_INTO_WALL) && this.isHookActive(HookActiveReason.ELYTRA_DAMAGE)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isStayingOnGroundSurface()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hooked$clipAtLedgeHookedMixin(CallbackInfoReturnable<Boolean> cir) {
        if (this.isHookActive(HookActiveReason.DISABLE_CLIP_AT_LEDGE)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    @NotNull
    public HookProcessor getHookProcessor() {
        return NullHookProcessor.INSTANCE;
    }

    @Inject(method={"aiStep()V"}, at={@At(value="RETURN")}, require=1)
    private void hooked$tickHooks(CallbackInfo ci) {
        this.getHookProcessor().tick((Player)this);
    }
}

