/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.mixin;

import dev.architectury.networking.NetworkManager;
import dev.thecodewarrior.hooked.hook.ServerHookProcessor;
import dev.thecodewarrior.hooked.network.GameRuleSyncS2CPacket;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    @Inject(method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;sendActivePlayerEffects(Lnet/minecraft/server/level/ServerPlayer;)V")}, require=1)
    private void onPlayerLogIn(Connection connection, ServerPlayer player, CommonListenerCookie clientData, CallbackInfo ci) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)GameRuleSyncS2CPacket.from(player.level().getGameRules()));
        ServerHookProcessor.INSTANCE.doInitialSync(player, player);
    }

    @Inject(method={"respawn(Lnet/minecraft/server/level/ServerPlayer;ZLnet/minecraft/world/entity/Entity$RemovalReason;)Lnet/minecraft/server/level/ServerPlayer;"}, at={@At(value="RETURN")}, require=1)
    private void respawnPlayer(ServerPlayer player, boolean alive, Entity.RemovalReason removalReason, CallbackInfoReturnable<ServerPlayer> cir) {
        ServerHookProcessor.INSTANCE.doInitialSync((ServerPlayer)cir.getReturnValue(), (ServerPlayer)cir.getReturnValue());
    }
}

