/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.mixin;

import dev.thecodewarrior.hooked.HookStats;
import dev.thecodewarrior.hooked.bridge.PlayerMixinBridge;
import dev.thecodewarrior.hooked.hook.HookActiveReason;
import dev.thecodewarrior.hooked.hook.HookProcessor;
import dev.thecodewarrior.hooked.hook.ServerHookProcessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
implements PlayerMixinBridge {
    @Override
    @NotNull
    public HookProcessor getHookProcessor() {
        return ServerHookProcessor.INSTANCE;
    }

    @Shadow
    public abstract void awardStat(Stat<?> var1, int var2);

    @Inject(method={"checkMovementStatistics(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void hooked$increaseTravelMotionStatsMixin(double dx, double dy, double dz, CallbackInfo ci) {
        if (this.isHookActive(HookActiveReason.TRAVEL_STATS)) {
            int cm = Math.round(Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz))) * 100.0f);
            if (cm > 0) {
                this.awardStat(HookStats.INSTANCE.getHookOneCmStat(), cm);
            }
            ci.cancel();
        }
    }

    @Inject(method={"triggerDimensionChangeTriggers(Lnet/minecraft/server/level/ServerLevel;)V"}, at={@At(value="TAIL")}, require=1)
    private void afterWorldChanged(ServerLevel origin, CallbackInfo ci) {
        ServerHookProcessor.INSTANCE.onPlayerWorldChanged((ServerPlayer)this);
    }
}

