/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.util;

import com.teamwizardry.librarianlib.math.Vec3dKt;
import dev.thecodewarrior.hooked.Hooked;
import dev.thecodewarrior.hooked.shade.quickhull3d.Point3d;
import dev.thecodewarrior.hooked.shade.quickhull3d.QuickHull3D;
import dev.thecodewarrior.hooked.util.BoundingShape;
import dev.thecodewarrior.hooked.util.ConstraintResult;
import dev.thecodewarrior.hooked.util.GeometryKt;
import dev.thecodewarrior.hooked.util.Hull;
import dev.thecodewarrior.hooked.util.LineSegment;
import dev.thecodewarrior.hooked.util.NoBoundingShape;
import dev.thecodewarrior.hooked.util.Point;
import dev.thecodewarrior.hooked.util.Polygon;
import dev.thecodewarrior.hooked.util.WireframeEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00198\u0006@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R0\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R$\u0010%\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00018\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020)0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001e\u00a8\u0006-"}, d2={"Ldev/thecodewarrior/hooked/util/DynamicHull;", "Ldev/thecodewarrior/hooked/util/BoundingShape;", "<init>", "()V", "", "Lnet/minecraft/world/phys/Vec3;", "newPoints", "", "update", "(Ljava/util/List;)Z", "point", "Ldev/thecodewarrior/hooked/util/ConstraintResult;", "constrain", "(Lnet/minecraft/world/phys/Vec3;)Ldev/thecodewarrior/hooked/util/ConstraintResult;", "", "threshold", "Ldev/thecodewarrior/hooked/util/LineSegment;", "toLine", "(D)Ldev/thecodewarrior/hooked/util/LineSegment;", "Ldev/thecodewarrior/hooked/util/Polygon;", "toPolygon", "(D)Ldev/thecodewarrior/hooked/util/Polygon;", "Ldev/thecodewarrior/hooked/util/Hull;", "toHull", "()Ldev/thecodewarrior/hooked/util/Hull;", "", "value", "pointSet", "Ljava/util/Set;", "getPointSet", "()Ljava/util/Set;", "setPointSet", "(Ljava/util/Set;)V", "points", "Ljava/util/List;", "getPoints", "()Ljava/util/List;", "shape", "Ldev/thecodewarrior/hooked/util/BoundingShape;", "getShape", "()Ldev/thecodewarrior/hooked/util/BoundingShape;", "Ldev/thecodewarrior/hooked/util/WireframeEdge;", "getWireframe", "wireframe", "Companion", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\ndev/thecodewarrior/hooked/util/DynamicHull\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,418:1\n1863#2,2:419\n1863#2,2:421\n1863#2,2:423\n1557#2:425\n1628#2,3:426\n1557#2:429\n1628#2,3:430\n37#3,2:433\n1682#4,6:435\n1137#4,2:441\n11195#4:443\n11530#4,3:444\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\ndev/thecodewarrior/hooked/util/DynamicHull\n*L\n87#1:419,2\n110#1:421,2\n123#1:423,2\n165#1:425\n165#1:426,3\n178#1:429\n178#1:430,3\n180#1:433,2\n184#1:435,6\n189#1:441,2\n191#1:443\n191#1:444,3\n*E\n"})
public final class DynamicHull
implements BoundingShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<? extends Vec3> pointSet = SetsKt.emptySet();
    @NotNull
    private List<? extends Vec3> points = CollectionsKt.emptyList();
    @NotNull
    private BoundingShape shape = NoBoundingShape.INSTANCE;
    @NotNull
    private static final Logger logger = Hooked.INSTANCE.getLogManager().makeLogger(DynamicHull.class);

    @NotNull
    public final Set<Vec3> getPointSet() {
        return this.pointSet;
    }

    private final void setPointSet(Set<? extends Vec3> value) {
        this.pointSet = value;
        this.points = CollectionsKt.toList((Iterable)value);
    }

    @NotNull
    public final List<Vec3> getPoints() {
        return this.points;
    }

    @NotNull
    public final BoundingShape getShape() {
        return this.shape;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean update(@NotNull List<? extends Vec3> newPoints) {
        BoundingShape boundingShape;
        Intrinsics.checkNotNullParameter(newPoints, (String)"newPoints");
        Set uniquePoints = CollectionsKt.toSet((Iterable)newPoints);
        if (Intrinsics.areEqual((Object)uniquePoints, this.pointSet)) {
            return false;
        }
        this.setPointSet(uniquePoints);
        DynamicHull dynamicHull = this;
        if (this.points.isEmpty()) {
            boundingShape = NoBoundingShape.INSTANCE;
        } else if (this.points.size() == 1) {
            boundingShape = new Point(this.points.get(0));
        } else {
            BoundingShape boundingShape2;
            DynamicHull dynamicHull2 = dynamicHull;
            try {
                BoundingShape boundingShape3;
                dynamicHull = dynamicHull2;
                LineSegment lineSegment = this.toLine(0.5);
                if (lineSegment != null) {
                    boundingShape3 = lineSegment;
                } else {
                    Polygon polygon = this.toPolygon(0.1);
                    boundingShape3 = polygon != null ? (BoundingShape)polygon : (BoundingShape)this.toHull();
                }
                boundingShape2 = boundingShape3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                dynamicHull = dynamicHull2;
                logger.warn("Error creating hull with points [{}]", (Object)CollectionsKt.joinToString$default((Iterable)this.points, (CharSequence)", ", null, null, (int)0, null, DynamicHull::update$lambda$0, (int)30, null), (Object)e);
                boundingShape2 = NoBoundingShape.INSTANCE;
            }
            boundingShape = boundingShape2;
        }
        dynamicHull.shape = boundingShape;
        return true;
    }

    @Override
    @NotNull
    public Set<WireframeEdge> getWireframe() {
        return this.shape.getWireframe();
    }

    @Override
    @NotNull
    public ConstraintResult constrain(@NotNull Vec3 point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.shape.constrain(point);
    }

    @Nullable
    public final LineSegment toLine(double threshold) {
        List points = CollectionsKt.toMutableList((Collection)this.points);
        if (points.size() < 2) {
            return null;
        }
        Object origin = null;
        origin = CollectionsKt.first((List)points);
        points.remove(origin);
        Object endpoint = null;
        endpoint = CollectionsKt.first((List)points);
        points.remove(endpoint);
        if (points.isEmpty()) {
            return new LineSegment((Vec3)origin, (Vec3)endpoint);
        }
        Vec3 axis = null;
        axis = Vec3dKt.minus((Vec3)((Vec3)endpoint), (Vec3)((Vec3)origin)).normalize();
        double max = 0.0;
        max = Vec3dKt.minus((Vec3)((Vec3)endpoint), (Vec3)((Vec3)origin)).length();
        double thresholdSq = threshold * threshold;
        Iterable $this$forEach$iv = points;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vec3 it = (Vec3)element$iv;
            boolean bl = false;
            Vec3 vec3 = Vec3dKt.minus((Vec3)it, (Vec3)((Vec3)origin));
            Vec3 vec32 = axis;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"element");
            double dot = Vec3dKt.dot((Vec3)vec3, (Vec3)vec32);
            if (Vec3dKt.minus((Vec3)Vec3dKt.times((Vec3)axis, (double)dot), (Vec3)Vec3dKt.minus((Vec3)it, (Vec3)((Vec3)origin))).lengthSqr() > thresholdSq) {
                return null;
            }
            if (dot < 0.0) {
                max += -dot;
                origin = it;
                axis = Vec3dKt.minus((Vec3)((Vec3)endpoint), (Vec3)origin).normalize();
                continue;
            }
            if (!(dot > max)) continue;
            max = dot;
            endpoint = it;
            axis = Vec3dKt.minus((Vec3)endpoint, (Vec3)((Vec3)origin)).normalize();
        }
        return new LineSegment((Vec3)origin, (Vec3)endpoint);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Polygon toPolygon(double threshold) {
        void $this$mapTo$iv$iv;
        Object element$iv4;
        Point3d[] vertices;
        Collection<Vec3> collection;
        Vec3 centroid;
        block13: {
            int n;
            QuickHull3D hull;
            block12: {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv2;
                Collection $this$map$iv;
                Object object;
                Iterable $this$mapTo$iv$iv3;
                if (this.points.size() < 3) {
                    return null;
                }
                if (this.points.size() == 3) {
                    Object[] objectArray = new Vec3[]{this.points.get(0), this.points.get(1), this.points.get(2)};
                    return new Polygon(CollectionsKt.listOf((Object[])objectArray));
                }
                Vec3 sum = null;
                sum = Vec3.ZERO;
                Iterable $this$forEach$iv = this.points;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Vec3 it = (Vec3)element$iv2;
                    boolean bl = false;
                    Vec3 vec3 = sum;
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"element");
                    sum = Vec3dKt.plus((Vec3)vec3, (Vec3)it);
                }
                Vec3 vec3 = sum;
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"element");
                centroid = Vec3dKt.times((Vec3)vec3, (double)(1.0 / (double)this.points.size()));
                double xx = 0.0;
                double xy = 0.0;
                double xz = 0.0;
                double yy = 0.0;
                double yz = 0.0;
                double zz = 0.0;
                Iterable $this$forEach$iv2 = this.points;
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    Vec3 it = (Vec3)element$iv3;
                    boolean bl = false;
                    Vec3 r = Vec3dKt.minus((Vec3)it, (Vec3)centroid);
                    xx += r.x * r.x;
                    xy += r.x * r.y;
                    xz += r.x * r.z;
                    yy += r.y * r.y;
                    yz += r.y * r.z;
                    zz += r.z * r.z;
                }
                double det_x = yy * zz - yz * yz;
                double det_y = xx * zz - xz * xz;
                double det_z = xx * yy - xy * xy;
                double det_max = Math.max(det_x, Math.max(det_y, det_z));
                if (det_max <= 0.0) {
                    return null;
                }
                Vec3 dir = det_max == det_x ? new Vec3(det_x, xz * yz - xy * zz, xy * yz - xz * yy) : (det_max == det_y ? new Vec3(xz * yz - xy * zz, det_y, xy * xz - yz * xx) : new Vec3(xy * yz - xz * yy, xy * xz - yz * xx, det_z));
                Vec3 normal = dir.normalize();
                Iterable $this$map$iv2 = this.points;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    Iterator it;
                    Vec3 vec32 = (Vec3)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    Vec3 vec33 = Vec3dKt.minus((Vec3)it, (Vec3)centroid);
                    Intrinsics.checkNotNull((Object)normal);
                    double distance = Vec3dKt.dot((Vec3)vec33, (Vec3)normal);
                    if (distance > threshold) {
                        return null;
                    }
                    object.add(Vec3dKt.minus((Vec3)Vec3dKt.minus((Vec3)it, (Vec3)Vec3dKt.times((Vec3)normal, (double)distance)), (Vec3)centroid));
                }
                List flatPoints = (List)destination$iv$iv;
                Intrinsics.checkNotNull((Object)normal);
                Vec3 otherPoint = Vec3dKt.times((Vec3)normal, (double)(threshold * (double)10));
                hull = new QuickHull3D();
                hull.setExplicitDistanceTolerance(threshold / 100.0);
                $this$mapTo$iv$iv3 = flatPoints;
                Collection collection2 = CollectionsKt.listOf((Object)GeometryKt.access$toPoint3d(otherPoint));
                object = hull;
                boolean $i$f$map2 = false;
                void $i$f$mapTo22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Vec3 distance = (Vec3)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add((Vec3)new Point3d(it.x, it.y, it.z));
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ((QuickHull3D)object).build(thisCollection$iv.toArray(new Point3d[0]));
                vertices = hull.getVertices();
                Intrinsics.checkNotNull((Object)vertices);
                Point3d[] $this$indexOfFirst$iv = vertices;
                boolean $i$f$indexOfFirst = false;
                int it = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < it; ++index$iv) {
                    Point3d it2 = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it2.x == otherPoint.x && it2.y == otherPoint.y && it2.z == otherPoint.z)) continue;
                    n = index$iv;
                    break block12;
                }
                n = -1;
            }
            int otherIndex = n;
            int[][] faces = hull.getFaces();
            Intrinsics.checkNotNull((Object)faces);
            Object[] $this$first$iv = (Object[])faces;
            boolean $i$f$first = false;
            for (Object element$iv4 : $this$first$iv) {
                int[] it = (int[])element$iv4;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!ArraysKt.contains((int[])it, (int)otherIndex))) {
                    continue;
                }
                break block13;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        int[] face = (int[])element$iv4;
        Intrinsics.checkNotNull((Object)face);
        int[] $this$map$iv = face;
        boolean $i$f$map = false;
        int[] it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var35_66 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Point3d point3d = vertices[it];
            Intrinsics.checkNotNullExpressionValue((Object)point3d, (String)"get(...)");
            collection.add(Vec3dKt.plus((Vec3)GeometryKt.access$toVec3d(point3d), (Vec3)centroid));
        }
        List list = (List)destination$iv$iv;
        return new Polygon(list);
    }

    @NotNull
    public final Hull toHull() {
        return new Hull(this.points);
    }

    private static final CharSequence update$lambda$0(Vec3 e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return "(" + e.x + "," + e.y + "," + e.z + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/thecodewarrior/hooked/util/DynamicHull$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "hooked-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

