/*
 * Decompiled with CFR 0.152.
 */
package dev.thecodewarrior.hooked.util;

import com.teamwizardry.librarianlib.core.util.Shorthand;
import com.teamwizardry.librarianlib.math.Vec3dKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/thecodewarrior/hooked/util/JumpHeightUtil;", "", "<init>", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/AABB;", "box", "Lnet/minecraft/world/phys/Vec3;", "movement", "", "maxHeight", "computeStepTarget", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/phys/Vec3;D)Lnet/minecraft/world/phys/Vec3;", "", "forward", "sideways", "yaw", "movementToDirection", "(FFF)Lnet/minecraft/world/phys/Vec3;", "", "computeJumpTargetOffsets", "(Lnet/minecraft/world/entity/player/Player;)Ljava/util/List;", "hooked-common"})
@SourceDebugExtension(value={"SMAP\nJumpHeightUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JumpHeightUtil.kt\ndev/thecodewarrior/hooked/util/JumpHeightUtil\n+ 2 Shorthand.kt\ncom/teamwizardry/librarianlib/core/util/Shorthand\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n74#2:115\n74#2:116\n1557#3:117\n1628#3,3:118\n*S KotlinDebug\n*F\n+ 1 JumpHeightUtil.kt\ndev/thecodewarrior/hooked/util/JumpHeightUtil\n*L\n89#1:115\n91#1:116\n101#1:117\n101#1:118,3\n*E\n"})
public final class JumpHeightUtil {
    @NotNull
    public static final JumpHeightUtil INSTANCE = new JumpHeightUtil();

    private JumpHeightUtil() {
    }

    @NotNull
    public final Vec3 computeStepTarget(@NotNull Player player, @NotNull AABB box, @NotNull Vec3 movement, double maxHeight) {
        boolean collidedZ;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        List collisionBoxes = player.level().getEntityCollisions((Entity)player, box.expandTowards(movement));
        Vec3 horizontal = movement.lengthSqr() == 0.0 ? movement : Entity.collideBoundingBox((Entity)((Entity)player), (Vec3)movement, (AABB)box, (Level)player.level(), (List)collisionBoxes);
        boolean collidedX = !(movement.x == horizontal.x);
        boolean bl = collidedZ = !(movement.z == horizontal.z);
        if (collidedX || collidedZ) {
            Vec3 ceilingHorizontal;
            Vec3 rising = Entity.collideBoundingBox((Entity)((Entity)player), (Vec3)new Vec3(movement.x, maxHeight, movement.z), (AABB)box, (Level)player.level(), (List)collisionBoxes);
            Vec3 ceiling = Entity.collideBoundingBox((Entity)((Entity)player), (Vec3)new Vec3(0.0, maxHeight, 0.0), (AABB)box.expandTowards(movement.x, 0.0, movement.z), (Level)player.level(), (List)collisionBoxes);
            if (ceiling.y < maxHeight && (ceilingHorizontal = Entity.collideBoundingBox((Entity)((Entity)player), (Vec3)new Vec3(movement.x, 0.0, movement.z), (AABB)box.move(ceiling), (Level)player.level(), (List)collisionBoxes).add(ceiling)).horizontalDistanceSqr() > rising.horizontalDistanceSqr()) {
                rising = ceilingHorizontal;
            }
            if (rising.horizontalDistanceSqr() > horizontal.horizontalDistanceSqr()) {
                Vec3 vec3 = rising.add(Entity.collideBoundingBox((Entity)((Entity)player), (Vec3)new Vec3(0.0, -rising.y + movement.y, 0.0), (AABB)box.move(rising), (Level)player.level(), (List)collisionBoxes));
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                return vec3;
            }
        }
        Intrinsics.checkNotNull((Object)horizontal);
        return horizontal;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec3 movementToDirection(float forward, float sideways, float yaw) {
        void z$iv;
        void y$iv;
        void x$iv;
        double s = Math.sin(Math.toRadians(yaw));
        double c = Math.cos(Math.toRadians(yaw));
        if ((double)(forward * forward + sideways * sideways) < 1.0E-7) {
            void y$iv2;
            void x$iv2;
            double d = -s;
            boolean bl = false;
            double z$iv2 = c;
            boolean $i$f$vec = false;
            return Shorthand.vec((double)x$iv2, (double)((double)y$iv2), (double)z$iv2);
        }
        double y$iv2 = (double)sideways * c - (double)forward * s;
        boolean z$iv2 = false;
        double $i$f$vec = (double)forward * c + (double)sideways * s;
        boolean $i$f$vec2 = false;
        Vec3 vec3 = Shorthand.vec((double)x$iv, (double)((double)y$iv), (double)z$iv).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        return vec3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vec3> computeJumpTargetOffsets(@NotNull Player player) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Vec3 direction = this.movementToDirection(player.zza, player.xxa, player.getYRot());
        Iterable $this$map$iv = CollectionsKt.listOf((Object)45);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf((float)it * (float)Math.PI / 180.0f));
        }
        List sampleAngles = (List)destination$iv$iv;
        double sampleDistance = 1.0;
        List samples = new ArrayList();
        samples.add(Vec3dKt.times((Vec3)direction, (double)sampleDistance));
        Iterator iterator2 = sampleAngles.iterator();
        while (iterator2.hasNext()) {
            float angle = ((Number)iterator2.next()).floatValue();
            Vec3 vec3 = direction.yRot(angle);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"rotateY(...)");
            samples.add(Vec3dKt.times((Vec3)vec3, (double)sampleDistance));
            Vec3 vec32 = direction.yRot(-angle);
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"rotateY(...)");
            samples.add(Vec3dKt.times((Vec3)vec32, (double)sampleDistance));
        }
        return samples;
    }
}

