/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator.client;

import io.github.raverbury.aggroindicator.ClientConfig;
import io.github.raverbury.aggroindicator.util.MathHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_12249;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class AlertRenderer {
    private static final Map<UUID, class_3545<Integer, Long>> entityUuidSet = new HashMap<UUID, class_3545<Integer, Long>>();
    private static class_2960 aggroIconIdentifier = AlertRenderer.getConfiguredAggroIcon(0);

    private AlertRenderer() {
    }

    public static void addAggroingMob(UUID mobUuid, boolean isAboutToAttack) {
        entityUuidSet.putIfAbsent(mobUuid, (class_3545<Integer, Long>)new class_3545((Object)0, (Object)0L));
    }

    public static void removeAggroingMob(UUID mobUuid) {
        entityUuidSet.remove(mobUuid);
    }

    public static void clearAggroingMobs() {
        entityUuidSet.clear();
    }

    public static void increaseSeenFrameCountForEntity(UUID mobUuid, long currentTick) {
        if (!entityUuidSet.containsKey(mobUuid)) {
            return;
        }
        class_3545 oldTuple = entityUuidSet.get(mobUuid);
        if (oldTuple == null) {
            oldTuple = new class_3545((Object)0, (Object)0L);
        }
        if ((Long)oldTuple.method_15441() >= currentTick) {
            return;
        }
        oldTuple.method_34964((Object)((Integer)oldTuple.method_15442() + 1));
        oldTuple.method_34965((Object)currentTick);
        entityUuidSet.replace(mobUuid, (class_3545<Integer, Long>)oldTuple);
    }

    public static void setAggroIcon(int aggroIconIndex) {
        aggroIconIdentifier = AlertRenderer.getConfiguredAggroIcon(aggroIconIndex);
    }

    public static void renderAlertIconForEntity(class_1297 entity, float partialTick, class_4587 matrix, class_4597 multiBufferSource, class_4184 camera) {
        boolean SHOULD_RETURN_EARLY_1;
        ClientConfig clientConfig = ClientConfig.cachedOrDefault();
        if (!clientConfig.renderAlertIcon) {
            return;
        }
        class_746 localPlayer = class_310.method_1551().field_1724;
        class_638 clientLevel = class_310.method_1551().field_1687;
        boolean bl = SHOULD_RETURN_EARLY_1 = entityUuidSet.isEmpty() || !(entity instanceof class_1308) || camera == null || clientLevel == null || localPlayer == null || localPlayer.method_6059(class_1294.field_5919) || localPlayer.method_6059(class_1294.field_38092);
        if (SHOULD_RETURN_EARLY_1) {
            return;
        }
        class_1308 mob = (class_1308)entity;
        int hideTimer = clientConfig.getHideTimer();
        class_3545 tuple = entityUuidSet.get(entity.method_5667());
        if (tuple == null) {
            tuple = new class_3545((Object)0, (Object)0L);
        }
        if (hideTimer > 0 && (Integer)tuple.method_15442() > hideTimer) {
            return;
        }
        if (mob.method_6059(class_1294.field_5905) || entity.method_5767()) {
            return;
        }
        if (!entityUuidSet.containsKey(entity.method_5667())) {
            return;
        }
        HashSet<String> blacklistedMobs = clientConfig.getBlacklistLookupTable();
        String entityRegistryName = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        boolean treatAsWhitelist = clientConfig.treatBlacklistAsWhitelist;
        boolean inList = blacklistedMobs.contains(entityRegistryName);
        if (treatAsWhitelist && !inList || !treatAsWhitelist && inList) {
            return;
        }
        float scaleToGui = 0.025f;
        boolean sneaking = entity.method_18276();
        float height = entity.method_17682() + 0.6f - (sneaking ? 0.25f : 0.0f);
        double x = class_3532.method_16436((double)partialTick, (double)entity.field_6014, (double)entity.method_23317());
        double y = class_3532.method_16436((double)partialTick, (double)entity.field_6036, (double)entity.method_23318());
        double z = class_3532.method_16436((double)partialTick, (double)entity.field_5969, (double)entity.method_23321());
        class_243 camPos = camera.method_71156();
        double camX = camPos.method_10216();
        double camY = camPos.method_10214();
        double camZ = camPos.method_10215();
        matrix.method_22903();
        matrix.method_22904(x - camX, y + (double)height - camY, z - camZ);
        Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
        matrix.method_22907((Quaternionfc)MathHelper.rotationDegrees(YP, -camera.method_19330()));
        matrix.method_22905(-scaleToGui, -scaleToGui, scaleToGui);
        if (clientConfig.scaleWithMobSize) {
            float size;
            matrix.method_22905(size *= (size = (float)entity.method_5829().method_995()) > 2.0f ? 0.9f : 1.0f, size, size);
        }
        float[] rgb = clientConfig.getAlertColorRGB();
        class_4588 vertexConsumer = multiBufferSource.method_73477(class_12249.method_76022((class_2960)aggroIconIdentifier));
        AlertRenderer._render(vertexConsumer, matrix, clientConfig.getClampedXOffset(), -(7.0f + clientConfig.getClampedYOffset()), clientConfig.getClampedAlertIconSize(), rgb);
        matrix.method_22909();
    }

    private static class_2960 getConfiguredAggroIcon(int style) {
        return switch (style) {
            case 1 -> class_2960.method_60654((String)"aggroindicator:textures/alert_icon_1.png");
            case 2 -> class_2960.method_60654((String)"aggroindicator:textures/alert_icon_2.png");
            default -> class_2960.method_60654((String)"aggroindicator:textures/alert_icon_0.png");
        };
    }

    private static void _render(class_4588 vertexConsumer, class_4587 poseStack, double x, double y, float size, float[] rgb) {
        Matrix4f m4f = poseStack.method_23760().method_23761();
        class_4587.class_4665 last = poseStack.method_23760();
        int LIGHT = 0xF000F0;
        float halfWidth = size / 2.0f;
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float a = 1.0f;
        vertexConsumer.method_22918((Matrix4fc)m4f, (float)((double)(-halfWidth) + x), (float)y, 0.25f).method_22913(0.0f, 0.0f).method_22915(r, g, b, 1.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(last, 0.0f, 0.0f, 0.0f);
        vertexConsumer.method_22918((Matrix4fc)m4f, (float)((double)(-halfWidth) + x), (float)((double)size + y), 0.25f).method_22913(0.0f, 1.0f).method_22915(r, g, b, 1.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(last, 0.0f, 0.0f, 0.0f);
        vertexConsumer.method_22918((Matrix4fc)m4f, (float)((double)halfWidth + x), (float)((double)size + y), 0.25f).method_22913(1.0f, 1.0f).method_22915(r, g, b, 1.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(last, 0.0f, 0.0f, 0.0f);
        vertexConsumer.method_22918((Matrix4fc)m4f, (float)((double)halfWidth + x), (float)y, 0.25f).method_22913(1.0f, 0.0f).method_22915(r, g, b, 1.0f).method_60803(0xF000F0).method_22922(class_4608.field_21444).method_60831(last, 0.0f, 0.0f, 0.0f);
    }
}

