/*
 * Decompiled with CFR 0.152.
 */
package com.github.raverbury.aggroindicator.event;

import com.github.raverbury.aggroindicator.config.ServerConfig;
import com.github.raverbury.aggroindicator.event.CustomLivingChangeTargetEvent;
import com.github.raverbury.aggroindicator.mixin.LivingEntityAccess;
import com.github.raverbury.aggroindicator.network.NetworkHandler;
import com.github.raverbury.aggroindicator.network.packet.S2CMobChangeTargetPacket;
import com.github.raverbury.aggroindicator.util.BrainAccess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerEventHandler {
    private static final Map<UUID, UUID> aggroList = new HashMap<UUID, UUID>();

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleEntityJoinLevelEvent);
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleLivingChangeTargetEvent);
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleCustomLivingChangeTargetEvent);
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleLivingDeathEvent);
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handleWorldUnloadEvent);
        MinecraftForge.EVENT_BUS.addListener(ServerEventHandler::handlePlayerLoggedOutEvent);
    }

    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() != null && event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        while (aggroList.values().remove(event.getEntity().m_20148_())) {
        }
    }

    public static void handleEntityJoinLevelEvent(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ((BrainAccess)livingEntity.m_6274_()).aggroIndicator$setBrainOwner(livingEntity);
        }
    }

    public static void handleWorldUnloadEvent(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        aggroList.clear();
    }

    public static void handleLivingChangeTargetEvent(LivingChangeTargetEvent event) {
        if (!(event.getEntity() instanceof Mob) && event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ServerEventHandler.processAggroChange((Mob)event.getEntity(), event.getNewTarget());
    }

    public static void handleCustomLivingChangeTargetEvent(CustomLivingChangeTargetEvent event) {
        if (!(event.getEntity() instanceof Mob) && event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ServerEventHandler.processAggroChange((Mob)event.getEntity(), event.getTarget());
    }

    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        if (event.isCanceled() || event.getEntity() == null || event.getEntity().m_9236_().m_5776_() || !(event.getEntity() instanceof Mob)) {
            return;
        }
        ServerEventHandler.processAggroChange((Mob)event.getEntity(), null);
    }

    private static void processAggroChange(@Nonnull Mob mob, @Nullable LivingEntity newTarget) {
        if (((LivingEntityAccess)mob).getDead()) {
            return;
        }
        LivingEntity oldTarget = ServerEventHandler.getOldTarget((LivingEntity)mob);
        if (oldTarget == newTarget) {
            return;
        }
        if (ServerEventHandler.shouldSendDeAggroPacket(oldTarget)) {
            NetworkHandler.sendToPlayer(new S2CMobChangeTargetPacket(mob.m_20148_(), false), (ServerPlayer)oldTarget);
        }
        if (ServerEventHandler.shouldSendAggroPacket(mob, newTarget)) {
            NetworkHandler.sendToPlayer(new S2CMobChangeTargetPacket(mob.m_20148_(), true), (ServerPlayer)newTarget);
        }
        ServerEventHandler.saveCurrentTarget(mob, newTarget);
    }

    private static boolean shouldSendDeAggroPacket(@Nullable LivingEntity oldTarget) {
        return oldTarget instanceof ServerPlayer;
    }

    private static boolean shouldSendAggroPacket(@Nonnull Mob mob, @Nullable LivingEntity newTarget) {
        String entityRegistryName = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_())).toString();
        boolean IS_BLACKLISTED = false;
        for (String item : (List)ServerConfig.SERVER_MOB_BLACKLIST.get()) {
            Pattern pattern = Pattern.compile(item = item.replace("*", ".*"), 2);
            if (!pattern.matcher(entityRegistryName).matches()) continue;
            IS_BLACKLISTED = true;
            break;
        }
        if (IS_BLACKLISTED) {
            return false;
        }
        return newTarget instanceof ServerPlayer;
    }

    private static LivingEntity getOldTarget(LivingEntity livingEntity) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            UUID oldTargetUUID = aggroList.computeIfAbsent(mob.m_20148_(), uuid -> null);
            if (oldTargetUUID == null) {
                return null;
            }
            Level level = mob.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return (LivingEntity)serverLevel.m_8791_(oldTargetUUID);
            }
            return null;
        }
        return null;
    }

    private static void saveCurrentTarget(Mob mob, @Nullable LivingEntity currentTarget) {
        UUID targetUUID = null;
        if (currentTarget != null) {
            targetUUID = currentTarget.m_20148_();
        }
        if (targetUUID == null) {
            aggroList.remove(mob.m_20148_());
        } else {
            aggroList.put(mob.m_20148_(), targetUUID);
        }
    }
}

