/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator;

import io.github.raverbury.aggroindicator.platform.Services;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommonClass {
    private static final Map<UUID, UUID> mobTargetPlayerMap = new HashMap<UUID, UUID>();

    public static void init() {
    }

    public static void clearMobTargetingThisPlayer(ServerPlayer serverPlayer) {
        while (mobTargetPlayerMap.values().remove(serverPlayer.getUUID())) {
        }
    }

    public static void clearMobTargetPlayerMap() {
        mobTargetPlayerMap.clear();
    }

    public static void livingChangeTarget(LivingEntity attacker, LivingEntity newTarget) {
        if (!(attacker instanceof Mob) || attacker.level().isClientSide) {
            return;
        }
        LivingEntity oldTarget = CommonClass.getOldTarget((Mob)attacker);
        if (oldTarget == newTarget) {
            return;
        }
        if (CommonClass.shouldSendDeaggroPacket(oldTarget)) {
            Services.NETWORK.sendS2CMobTargetPlayerPacket((ServerPlayer)oldTarget, attacker.getUUID(), false, false);
        }
        if (CommonClass.shouldSendAggroPacket((Mob)attacker, newTarget)) {
            Services.NETWORK.sendS2CMobTargetPlayerPacket((ServerPlayer)newTarget, attacker.getUUID(), true, false);
        }
        CommonClass.saveCurrentTarget((Mob)attacker, newTarget);
    }

    public static void livingAboutToAttack(LivingEntity attacker, boolean aboutToAttack) {
        Entity entity;
        if (mobTargetPlayerMap.containsKey(attacker.getUUID()) && (entity = ((ServerLevel)attacker.level()).getEntity(mobTargetPlayerMap.get(attacker.getUUID()))) instanceof Player) {
            Player player = (Player)entity;
            Services.NETWORK.sendS2CMobTargetPlayerPacket((ServerPlayer)player, attacker.getUUID(), true, aboutToAttack);
        }
    }

    private static boolean shouldSendDeaggroPacket(LivingEntity oldTarget) {
        return oldTarget instanceof ServerPlayer;
    }

    private static boolean shouldSendAggroPacket(Mob mob, LivingEntity newTarget) {
        return newTarget instanceof ServerPlayer;
    }

    private static void saveCurrentTarget(Mob attacker, LivingEntity currentTarget) {
        UUID targetUUID = null;
        if (currentTarget != null) {
            targetUUID = currentTarget.getUUID();
        }
        if (targetUUID == null) {
            mobTargetPlayerMap.remove(attacker.getUUID());
        } else {
            mobTargetPlayerMap.put(attacker.getUUID(), targetUUID);
        }
    }

    private static LivingEntity getOldTarget(Mob attacker) {
        UUID oldTargetUUID = mobTargetPlayerMap.computeIfAbsent(attacker.getUUID(), uuid -> null);
        if (oldTargetUUID == null) {
            return null;
        }
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (LivingEntity)serverLevel.getEntity(oldTargetUUID);
        }
        return null;
    }
}

