/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator.mixin;

import io.github.raverbury.aggroindicator.CommonClass;
import io.github.raverbury.aggroindicator.accessors.BrainAccess;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Brain.class})
public abstract class BrainMixin
implements BrainAccess {
    @Shadow
    @Final
    private Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> memories;
    @Unique
    private LivingEntity aggroindicator$brainOwner = null;

    @Inject(method={"setMemoryInternal"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    private <U> void aggroindicator$dispatchCLCTEOnSetMemory(MemoryModuleType<U> memoryModuleType, Optional<? extends ExpirableValue<?>> memoryValue, CallbackInfo ci) {
        if (memoryModuleType == MemoryModuleType.ATTACK_TARGET && this.aggroindicator$brainOwner != null) {
            if (memoryValue.isPresent()) {
                CommonClass.livingChangeTarget(this.aggroindicator$brainOwner, (LivingEntity)memoryValue.get().getValue());
            } else {
                CommonClass.livingChangeTarget(this.aggroindicator$brainOwner, null);
            }
        }
    }

    @Inject(method={"clearMemories"}, at={@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;")})
    private void aggroindicator$dispatchCLCTEOnClear(CallbackInfo ci) {
        if (this.memories.containsKey(MemoryModuleType.ATTACK_TARGET) && this.aggroindicator$brainOwner != null) {
            CommonClass.livingChangeTarget(this.aggroindicator$brainOwner, null);
        }
    }

    @Override
    public void aggroindicator$setBrainOwner(LivingEntity owner) {
        this.aggroindicator$brainOwner = owner;
    }

    @Override
    public LivingEntity aggroindicator$getBrainOwner() {
        return this.aggroindicator$brainOwner;
    }
}

