/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator;

import io.github.raverbury.aggroindicator.network.packet.S2CMobChangeTargetPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggroIndicator
implements ModInitializer {
    public static final String MOD_ID = "aggroindicator";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"aggroindicator");
    private static final Map<UUID, UUID> mobTargetPlayerMap = new HashMap<UUID, UUID>();

    public static void livingChangeTarget(class_1309 attacker, class_1309 newTarget) {
        S2CMobChangeTargetPacket packet;
        if (!(attacker instanceof class_1308) || attacker.method_37908().method_8608()) {
            return;
        }
        class_1309 oldTarget = AggroIndicator.getOldTarget((class_1308)attacker);
        if (oldTarget == newTarget) {
            return;
        }
        if (AggroIndicator.shouldSendDeaggroPacket(oldTarget)) {
            packet = new S2CMobChangeTargetPacket(attacker.method_5667(), false);
            ServerPlayNetworking.send((class_3222)((class_3222)oldTarget), (FabricPacket)packet);
        }
        if (AggroIndicator.shouldSendAggroPacket((class_1308)attacker, newTarget)) {
            packet = new S2CMobChangeTargetPacket(attacker.method_5667(), true);
            ServerPlayNetworking.send((class_3222)((class_3222)newTarget), (FabricPacket)packet);
        }
        AggroIndicator.saveCurrentTarget((class_1308)attacker, newTarget);
    }

    public static void clearMobTargetPlayerMap() {
        mobTargetPlayerMap.clear();
    }

    public static void clearMobTargetingThisPlayer(class_3222 player) {
        while (mobTargetPlayerMap.values().remove(player.method_5667())) {
        }
    }

    private static boolean shouldSendDeaggroPacket(class_1309 oldTarget) {
        return oldTarget instanceof class_3222;
    }

    private static boolean shouldSendAggroPacket(class_1308 mob, class_1309 newTarget) {
        return newTarget instanceof class_3222;
    }

    private static void saveCurrentTarget(class_1308 attacker, class_1309 currentTarget) {
        UUID targetUUID = null;
        if (currentTarget instanceof class_1657) {
            targetUUID = currentTarget.method_5667();
        }
        if (targetUUID == null) {
            mobTargetPlayerMap.remove(attacker.method_5667());
        } else {
            mobTargetPlayerMap.put(attacker.method_5667(), targetUUID);
        }
    }

    private static class_1309 getOldTarget(class_1308 attacker) {
        UUID oldTargetUUID = mobTargetPlayerMap.computeIfAbsent(attacker.method_5667(), uuid -> null);
        if (oldTargetUUID == null) {
            return null;
        }
        class_1937 class_19372 = attacker.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return (class_1309)serverLevel.method_14190(oldTargetUUID);
        }
        return null;
    }

    public void onInitialize() {
    }
}

