/*
 * Decompiled with CFR 0.152.
 */
package io.github.raverbury.aggroindicator.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.raverbury.aggroindicator.client.config.ClientConfig;
import io.github.raverbury.aggroindicator.util.MathHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1308;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class AlertRenderer {
    private static final Map<UUID, class_3545<Integer, Long>> entityUuidSet = new HashMap<UUID, class_3545<Integer, Long>>();
    private static class_2960 aggroIcon = AlertRenderer.getConfiguredAggroIcon(0);

    private AlertRenderer() {
    }

    public static void addAggroingMob(UUID mobUuid, boolean isAboutToAttack) {
        entityUuidSet.put(mobUuid, (class_3545<Integer, Long>)new class_3545((Object)0, (Object)0L));
    }

    public static void removeAggroingMob(UUID mobUuid) {
        entityUuidSet.remove(mobUuid);
    }

    public static void increaseSeenFrameCount(UUID mobUuid, long currentTick) {
        if (!entityUuidSet.containsKey(mobUuid)) {
            return;
        }
        class_3545<Integer, Long> oldTuple = entityUuidSet.get(mobUuid);
        if ((Long)oldTuple.method_15441() >= currentTick) {
            return;
        }
        oldTuple.method_34964((Object)((Integer)oldTuple.method_15442() + 1));
        oldTuple.method_34965((Object)currentTick);
        entityUuidSet.replace(mobUuid, oldTuple);
    }

    public static void clearAggroingMobs() {
        entityUuidSet.clear();
    }

    public static void renderAlertIcon(float partialTick, class_4587 matrix, class_4184 camera) {
        ClientConfig clientConfig = ClientConfig.cachedOrDefault();
        if (!clientConfig.renderAlertIcon) {
            return;
        }
        class_746 localPlayer = class_310.method_1551().field_1724;
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (entityUuidSet.isEmpty() || camera == null || clientLevel == null || localPlayer == null || localPlayer.method_6059(class_1294.field_5919) || localPlayer.method_6059(class_1294.field_38092)) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        aggroIcon = AlertRenderer.getConfiguredAggroIcon(clientConfig.alertIconStyle);
        List nearbyMobs = clientLevel.method_8390(class_1308.class, localPlayer.method_5829().method_1014((double)clientConfig.getClampedRenderRange()), mob -> true);
        HashSet<String> blacklistedMobs = clientConfig.getBlacklistLookupTable();
        for (class_1308 mob2 : nearbyMobs) {
            int hideTimer;
            if (!entityUuidSet.containsKey(mob2.method_5667()) || (hideTimer = clientConfig.getHideTimer()) > 0 && (Integer)entityUuidSet.get(mob2.method_5667()).method_15442() > hideTimer) continue;
            String entityRegistryName = ((class_5321)class_7923.field_41177.method_29113((Object)mob2.method_5864()).get()).method_29177().toString();
            boolean isWhitelist = clientConfig.treatBlacklistAsWhitelist;
            boolean inList = blacklistedMobs.contains(entityRegistryName);
            if (isWhitelist && !inList || !isWhitelist && inList || mob2.method_6059(class_1294.field_5905) || mob2.method_5767()) continue;
            float scaleToGui = 0.025f;
            boolean sneaking = mob2.method_5715();
            float height = (float)(mob2.method_5829().method_17940() + (double)0.6f - (double)(sneaking ? 0.25f : 0.0f));
            double x = class_3532.method_16436((double)partialTick, (double)mob2.field_6014, (double)mob2.method_23317());
            double y = class_3532.method_16436((double)partialTick, (double)mob2.field_6036, (double)mob2.method_23318());
            double z = class_3532.method_16436((double)partialTick, (double)mob2.field_5969, (double)mob2.method_23321());
            class_243 camPos = camera.method_19326();
            double camX = camPos.method_10216();
            double camY = camPos.method_10214();
            double camZ = camPos.method_10215();
            matrix.method_22903();
            matrix.method_22904(x - camX, y + (double)height - camY, z - camZ);
            Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
            matrix.method_22907(MathHelper.rotationDegrees(YP, -camera.method_19330()));
            matrix.method_22905(-scaleToGui, -scaleToGui, scaleToGui);
            if (clientConfig.scaleWithMobSize) {
                float size;
                matrix.method_22905(size *= (size = (float)mob2.method_5829().method_995()) > 2.0f ? 0.9f : 1.0f, size, size);
            }
            float[] colors = clientConfig.getColors();
            AlertRenderer._render(matrix, clientConfig.getClampedXOffset(), -(7.0f + clientConfig.getClampedYOffset()), clientConfig.getClampedAlertIconSize(), false, colors);
            matrix.method_22909();
        }
        RenderSystem.disableBlend();
    }

    private static class_2960 getConfiguredAggroIcon(int style) {
        return switch (style) {
            case 1 -> new class_2960("aggroindicator:textures/alert_icon_1.png");
            case 2 -> new class_2960("aggroindicator:textures/alert_icon_2.png");
            default -> new class_2960("aggroindicator:textures/alert_icon_0.png");
        };
    }

    private static void _render(class_4587 matrix, double x, double y, float size, boolean isAboutToAttack, float[] colors) {
        RenderSystem.setShaderColor((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)aggroIcon);
        RenderSystem.enableBlend();
        Matrix4f m4f = matrix.method_23760().method_23761();
        float halfWidth = size / 2.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        class_293 format = new class_293(ImmutableMap.builder().put((Object)"Position", (Object)new class_296(0, class_296.class_297.field_1623, class_296.class_298.field_1633, 3)).put((Object)"UV0", (Object)new class_296(0, class_296.class_297.field_1623, class_296.class_298.field_1636, 2)).build());
        buffer.method_1328(class_293.class_5596.field_27382, format);
        buffer.method_22918(m4f, (float)((double)(-halfWidth) + x), (float)y, 0.25f).method_22913(0.0f, 0.0f).method_1344();
        buffer.method_22918(m4f, (float)((double)(-halfWidth) + x), (float)((double)size + y), 0.25f).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22918(m4f, (float)((double)halfWidth + x), (float)((double)size + y), 0.25f).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(m4f, (float)((double)halfWidth + x), (float)y, 0.25f).method_22913(1.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

