/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.JEI;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.splendidslimes.JEI.PlortPressingCategory;
import io.github.chakyl.splendidslimes.JEI.PlortRecipe;
import io.github.chakyl.splendidslimes.JEI.PlortRippingCategory;
import io.github.chakyl.splendidslimes.JEI.SlimeInfoCategory;
import io.github.chakyl.splendidslimes.JEI.SlimeTraitsCategory;
import io.github.chakyl.splendidslimes.JEI.TraitRecipe;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.data.SlimeBreedRegistry;
import io.github.chakyl.splendidslimes.recipe.PlortPressingRecipe;
import io.github.chakyl.splendidslimes.recipe.PlortRippingRecipe;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.screen.PlortPressScreen;
import io.github.chakyl.splendidslimes.util.SlimeData;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class SplendidSlimesJei
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("splendid_slimes", "plugin");

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)ModElements.Items.PLORT.get(), (IIngredientSubtypeInterpreter)new ModelSubtypes());
        reg.registerSubtypeInterpreter((Item)ModElements.Items.SLIME_HEART.get(), (IIngredientSubtypeInterpreter)new ModelSubtypes());
        reg.registerSubtypeInterpreter((Item)ModElements.Items.SLIME_ITEM.get(), (IIngredientSubtypeInterpreter)new ModelSubtypes());
        reg.registerSubtypeInterpreter((Item)ModElements.Items.SPLENDID_SLIME_SPAWN_EGG.get(), (IIngredientSubtypeInterpreter)new ModelSubtypes());
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new PlortRippingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new PlortPressingCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SlimeInfoCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new SlimeTraitsCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List rippingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)PlortRippingRecipe.Type.INSTANCE);
        registration.addRecipes(PlortRippingCategory.TYPE, rippingRecipes);
        List pressingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)PlortPressingRecipe.Type.INSTANCE);
        registration.addRecipes(PlortPressingCategory.TYPE, pressingRecipes);
        ArrayList<PlortRecipe> breedRecipes = new ArrayList<PlortRecipe>();
        for (SlimeBreed breed : SlimeBreedRegistry.INSTANCE.getValues()) {
            breedRecipes.add(new PlortRecipe(breed));
        }
        registration.addRecipes(SlimeInfoCategory.TYPE, breedRecipes);
        ArrayList<TraitRecipe> traitRecipes = new ArrayList<TraitRecipe>();
        for (SlimeBreed breed : SlimeBreedRegistry.INSTANCE.getValues()) {
            int traitCount = breed.traits().size();
            for (int i = 0; i < traitCount; ++i) {
                traitRecipes.add(new TraitRecipe(breed, breed.traits().get(i)));
            }
        }
        registration.addRecipes(SlimeTraitsCategory.TYPE, traitRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ModElements.Blocks.PLORT_RIPPIT.get()), new RecipeType[]{PlortRippingCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)ModElements.Blocks.PLORT_PRESS.get()), new RecipeType[]{PlortPressingCategory.TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(PlortPressScreen.class, 80, 26, 20, 30, new RecipeType[]{PlortPressingCategory.TYPE});
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }

    private static class ModelSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private ModelSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            DynamicHolder<SlimeBreed> slimeData;
            String accessor = "slime";
            if (stack.m_41720_() == ModElements.Items.PLORT.get()) {
                accessor = "plort";
            }
            if (!(slimeData = stack.m_41720_() == ModElements.Items.SPLENDID_SLIME_SPAWN_EGG.get() ? SlimeData.getSlimeFromEgg(stack) : SlimeData.getSlimeData(stack, accessor)).isBound()) {
                return "NULL";
            }
            return slimeData.getId().toString();
        }
    }
}

