/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.events;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.splendidslimes.SplendidSlimes;
import io.github.chakyl.splendidslimes.client.Keybindings;
import io.github.chakyl.splendidslimes.client.model.HatModel;
import io.github.chakyl.splendidslimes.client.model.PlortModel;
import io.github.chakyl.splendidslimes.client.model.SlimeEntityModel;
import io.github.chakyl.splendidslimes.client.renderer.SlimeEntityRenderer;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.item.ItemProjectile.ItemProjectileRenderer;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.screen.PlortPressScreen;
import io.github.chakyl.splendidslimes.util.SlimeData;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="splendid_slimes")
public class ClientModEvents {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModElements.Entities.SPLENDID_SLIME.get(), SlimeEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModElements.Entities.TARR.get(), SlimeEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModElements.Entities.ITEM_PROJECTILE.get(), ItemProjectileRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModElements.Entities.SPLENDID_SLIME.get()), SlimeEntityRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModElements.Entities.TARR.get()), SlimeEntityRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModElements.Entities.ITEM_PROJECTILE.get()), ItemProjectileRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModElements.Menus.PLORT_PRESS_MENU.get()), PlortPressScreen::new);
        });
    }

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(Keybindings.INSTANCE.slimeVacModeKey);
    }

    @SubscribeEvent
    public static void mrl(ModelEvent.RegisterAdditional e) {
        e.register(new ResourceLocation("splendid_slimes", "item/data_model_base"));
    }

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SlimeEntityRenderer.SPLENDID_SLIME_BASE, SlimeEntityModel::createInnerBodyLayer);
    }

    @SubscribeEvent
    public static void addPlortModel(ModelEvent.RegisterAdditional e) {
        Set locs = Minecraft.m_91087_().m_91098_().m_214159_("models", loc -> "splendid_slimes".equals(loc.m_135827_()) && loc.m_135815_().contains("/plort/") && loc.m_135815_().endsWith(".json")).keySet();
        for (ResourceLocation s : locs) {
            String path = s.m_135815_().substring("models/".length(), s.m_135815_().length() - ".json".length());
            e.register(new ResourceLocation("splendid_slimes", path));
        }
    }

    @SubscribeEvent
    public static void replacePlortModel(ModelEvent.ModifyBakingResult e) {
        ModelResourceLocation key = new ModelResourceLocation(SplendidSlimes.loc("plort"), "inventory");
        BakedModel oldModel = (BakedModel)e.getModels().get(key);
        if (oldModel != null) {
            e.getModels().put(key, new PlortModel(oldModel, e.getModelBakery()));
        }
    }

    @SubscribeEvent
    public static void addHatModel(ModelEvent.RegisterAdditional e) {
        Set locs = Minecraft.m_91087_().m_91098_().m_214159_("models", loc -> "splendid_slimes".equals(loc.m_135827_()) && loc.m_135815_().contains("/hat/") && loc.m_135815_().endsWith(".json")).keySet();
        for (ResourceLocation s : locs) {
            String path = s.m_135815_().substring("models/".length(), s.m_135815_().length() - ".json".length());
            e.register(new ResourceLocation("splendid_slimes", path));
        }
    }

    @SubscribeEvent
    public static void replaceHatModel(ModelEvent.ModifyBakingResult e) {
        ModelResourceLocation key = new ModelResourceLocation(SplendidSlimes.loc("hat"), "inventory");
        BakedModel oldModel = (BakedModel)e.getModels().get(key);
        if (oldModel != null) {
            e.getModels().put(key, new HatModel(oldModel, e.getModelBakery()));
        }
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> {
            DynamicHolder<SlimeBreed> slime = SlimeData.getSlimeData(stack, "slime");
            int color = 0xFFFFFF;
            if (slime.isBound()) {
                color = ((SlimeBreed)slime.get()).getColor();
            }
            return color;
        }, new ItemLike[]{(ItemLike)ModElements.Items.SLIME_HEART.get()});
        e.register((stack, tint) -> {
            DynamicHolder<SlimeBreed> slime = SlimeData.getSlimeData(stack, "slime");
            int color = 0xFFFFFF;
            if (slime.isBound()) {
                color = ((SlimeBreed)slime.get()).getColor();
            }
            return color;
        }, new ItemLike[]{(ItemLike)ModElements.Items.SLIME_ITEM.get()});
    }
}

