/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.blockentity;

import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import io.github.chakyl.splendidslimes.block.PlortRippitBlock;
import io.github.chakyl.splendidslimes.item.PlortItem;
import io.github.chakyl.splendidslimes.recipe.PlortRippingRecipe;
import io.github.chakyl.splendidslimes.registry.ModElements;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class PlortRippitBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    private int RIPPIT_PROCESSING_TIME = 100;
    protected int progress = 0;
    protected String slimeType = "";
    protected final RippitItemHandler inventory = new RippitItemHandler();

    public PlortRippitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModElements.BlockEntities.PLORT_RIPPIT.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.inventory.getStackInSlot(0).m_41619_() && this.hasRecipe()) {
            if (this.progress == 0 && !((Boolean)state.m_61143_((Property)PlortRippitBlock.WORKING)).booleanValue()) {
                BlockState newState = (BlockState)state.m_61124_((Property)PlortRippitBlock.WORKING, (Comparable)Boolean.valueOf(true));
                level.m_46597_(pos, newState);
                this.setSlimeType(this.inventory.getStackInSlot(0).m_41737_("plort").m_128423_("id").toString().replace("\"", ""));
                level.m_5594_(null, pos, SoundEvents.f_215697_, SoundSource.BLOCKS, 1.0f, 0.9f);
                level.m_5594_(null, pos, SoundEvents.f_215692_, SoundSource.BLOCKS, 1.0f, 0.9f);
            } else if (this.progress >= this.RIPPIT_PROCESSING_TIME) {
                this.craftItem(pos, state);
                this.m_6596_();
                this.progress = 0;
            } else {
                ++this.progress;
            }
        }
    }

    private boolean hasRecipe() {
        Optional<PlortRippingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack input = recipe.get().getInputItem(this.m_58904_().m_9598_());
        return this.inventory.getStackInSlot(0).m_150930_(input.m_41720_());
    }

    private Optional<PlortRippingRecipe> getCurrentRecipe() {
        SimpleContainer newInventory = new SimpleContainer(this.inventory.getSlots());
        ItemStack newItemStack = this.inventory.getStackInSlot(0).m_41777_();
        newItemStack.m_41764_(1);
        newInventory.m_6836_(0, newItemStack);
        return this.f_58857_.m_7465_().m_44015_((RecipeType)PlortRippingRecipe.Type.INSTANCE, (Container)newInventory, this.f_58857_);
    }

    private void craftItem(BlockPos pos, BlockState state) {
        Optional<PlortRippingRecipe> recipe = this.getCurrentRecipe();
        NonNullList<ItemStack> results = recipe.get().getResults(null);
        ItemStack outputItem = Items.f_41852_.m_7968_();
        List<Integer> weights = recipe.get().getWeights(null);
        int weightTotal = 0;
        int currentWeight = 0;
        for (Integer weight : weights) {
            weightTotal += weight.intValue();
        }
        int result = 1;
        if (weightTotal > 1) {
            Random r = new Random();
            result = r.nextInt(weightTotal) + 1;
        }
        for (int i = 0; i < results.size(); ++i) {
            if ((currentWeight += weights.get(i).intValue()) < result) continue;
            outputItem = (ItemStack)results.get(i);
            break;
        }
        Block.m_152435_((Level)this.f_58857_, (BlockPos)pos, (Direction)((Direction)state.m_61143_((Property)PlortRippitBlock.f_54117_)).m_122424_(), (ItemStack)outputItem.m_41777_());
        this.f_58857_.m_5594_(null, pos, SoundEvents.f_215690_, SoundSource.BLOCKS, 0.7f, 0.95f + this.f_58857_.m_213780_().m_188501_() * 0.1f);
        if (this.inventory.getStackInSlot(0).m_41613_() == 1) {
            BlockState newState = (BlockState)state.m_61124_((Property)PlortRippitBlock.WORKING, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_46597_(pos, newState);
        }
        this.slimeType = "";
        this.inventory.getStackInSlot(0).m_41774_(1);
    }

    public void setSlimeType(String type) {
        this.slimeType = type;
    }

    public String getSlimeType() {
        return this.slimeType;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean insertItem(ItemStack itemStack) {
        if (this.inventory.isItemValid(0, itemStack)) {
            ItemStack modifiedStack = itemStack.m_41777_();
            modifiedStack.m_41764_(1);
            this.inventory.setStackInSlot(0, modifiedStack);
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128359_("slimeType", this.slimeType);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("progress");
        this.slimeType = tag.m_128461_("slimeType");
    }

    public class RippitItemHandler
    extends InternalItemHandler {
        public RippitItemHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.getStackInSlot(0).m_41619_() && stack.m_41720_() instanceof PlortItem && stack.m_41782_()) {
                CompoundTag plortTag = stack.m_41737_("plort");
                return plortTag != null && plortTag.m_128441_("id");
            }
            return false;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        protected void onContentsChanged(int slot) {
            PlortRippitBlockEntity.this.m_6596_();
        }
    }
}

