/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item;

import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.util.SlimeComfortUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SlimeInspector
extends Item {
    public SlimeInspector(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        list.add((Component)Component.m_237115_((String)"info.splendid_slimes.slime_inspector").m_130940_(ChatFormatting.GRAY));
    }

    public void runInspection(Player player, SplendidSlime splendidSlime) {
        List<SplendidSlime> nearbyFriends;
        if (player.m_36335_().m_41519_((Item)ModElements.Items.SLIME_INSPECTOR.get())) {
            return;
        }
        boolean allGood = true;
        ArrayList<MutableComponent> messagesToSend = new ArrayList<MutableComponent>();
        if (SlimeComfortUtils.slimeIsSuffocated(splendidSlime)) {
            messagesToSend.add(Component.m_237115_((String)"info.splendid_slimes.slime_inspector.suffocating").m_130940_(ChatFormatting.DARK_RED));
            allGood = false;
        }
        if ((nearbyFriends = SlimeComfortUtils.getNearbyFriends(splendidSlime)).size() > 8) {
            messagesToSend.add(Component.m_237110_((String)"info.splendid_slimes.slime_inspector.crowded", (Object[])new Object[]{nearbyFriends.size()}).m_130940_(ChatFormatting.GOLD));
            for (SplendidSlime splendidSlime2 : nearbyFriends) {
                splendidSlime2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 120, 0, false, false));
            }
        }
        if (SlimeComfortUtils.diverseTraitCheck(splendidSlime)) {
            messagesToSend.add(Component.m_237115_((String)"info.splendid_slimes.slime_inspector.diverse_failure").m_130940_(ChatFormatting.LIGHT_PURPLE));
            allGood = false;
        }
        if (SlimeComfortUtils.aquaticTraitCheck(splendidSlime)) {
            messagesToSend.add(Component.m_237115_((String)"info.splendid_slimes.slime_inspector.aquatic_failure").m_130940_(ChatFormatting.AQUA));
            allGood = false;
        }
        if (allGood) {
            messagesToSend.add(Component.m_237115_((String)"info.splendid_slimes.slime_inspector.all_good").m_130940_(ChatFormatting.GREEN));
        } else {
            messagesToSend.add(Component.m_237115_((String)"info.splendid_slimes.slime_inspector.not_happy").m_130940_(ChatFormatting.RED));
        }
        if (player.m_9236_().f_46443_) {
            for (Component component : messagesToSend) {
                player.m_213846_(component);
            }
        }
        splendidSlime.m_5496_(SoundEvents.f_215676_, 1.0f, 0.2f);
        player.m_36335_().m_41524_((Item)ModElements.Items.SLIME_INSPECTOR.get(), 120);
    }
}

