/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.blockentity;

import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import io.github.chakyl.splendidslimes.SlimyConfig;
import io.github.chakyl.splendidslimes.block.SlimeIncubatorBlock;
import io.github.chakyl.splendidslimes.recipe.PlortPressingRecipe;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.screen.PlortPressMenu;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class PlortPressBlockEntity
extends BlockEntity
implements TickingBlockEntity,
MenuProvider {
    protected final ContainerData data;
    private int progress = 0;
    private int PRESSING_TIME = SlimyConfig.plortPressingTime;
    private final ItemStackHandler topInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PlortPressBlockEntity.this.m_6596_();
        }
    };
    private final ItemStackHandler bottomInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PlortPressBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<ItemStackHandler> topOptional = LazyOptional.of(() -> this.topInventory);
    private final LazyOptional<ItemStackHandler> bottomOptional = LazyOptional.of(() -> this.bottomInventory);

    public PlortPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModElements.BlockEntities.PLORT_PRESS.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> PlortPressBlockEntity.this.progress;
                    case 1 -> PlortPressBlockEntity.this.PRESSING_TIME;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        PlortPressBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        PlortPressBlockEntity.this.PRESSING_TIME = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (level.m_46467_() % 10L == 0L) {
            if (this.hasRecipe()) {
                BlockState newState;
                if (this.progress == 0) {
                    newState = (BlockState)state.m_61124_((Property)SlimeIncubatorBlock.WORKING, (Comparable)Boolean.valueOf(true));
                    level.m_46597_(pos, newState);
                }
                this.progress += 10;
                PlortPressBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (this.progress >= this.PRESSING_TIME) {
                    this.craftItem();
                    newState = (BlockState)state.m_61124_((Property)SlimeIncubatorBlock.WORKING, (Comparable)Boolean.valueOf(false));
                    level.m_46597_(pos, newState);
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return this.bottomOptional.cast();
            }
            return this.topOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.topOptional.invalidate();
        this.bottomOptional.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public LazyOptional<ItemStackHandler> getTopOptional() {
        return this.topOptional;
    }

    public LazyOptional<ItemStackHandler> getBottomOptional() {
        return this.bottomOptional;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.m_6836_(0, this.topInventory.getStackInSlot(0));
        inventory.m_6836_(1, this.bottomInventory.getStackInSlot(0));
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PlortPressMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    private void craftItem() {
        Optional<PlortPressingRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        int resultCount = result.m_41613_();
        ItemStack outputSlot = this.bottomInventory.getStackInSlot(0);
        this.topInventory.extractItem(0, recipe.get().getInputItem(null).m_41613_(), false);
        if (outputSlot.m_41613_() > 0 && this.canInsertItemIntoOutputSlot(outputSlot, result) && this.canInsertAmountIntoOutputSlot(outputSlot, resultCount)) {
            outputSlot.m_41764_(outputSlot.m_41613_() + resultCount);
        } else {
            this.bottomInventory.setStackInSlot(0, result.m_41777_());
        }
    }

    private boolean hasRecipe() {
        Optional<PlortPressingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack input = recipe.get().getInputItem(this.m_58904_().m_9598_());
        ItemStack output = recipe.get().getOutputItem(this.m_58904_().m_9598_());
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        ItemStack inputSlot = this.topInventory.getStackInSlot(0);
        ItemStack outputSlot = this.bottomInventory.getStackInSlot(0);
        return output.m_41619_() && this.slotMatches(outputSlot, result) && this.canInsertAmountIntoOutputSlot(outputSlot, result.m_41613_()) && this.canInsertItemIntoOutputSlot(outputSlot, result) || this.validateFusion(input, inputSlot, output, outputSlot);
    }

    private boolean slotMatches(ItemStack slot, ItemStack recipe) {
        return slot.m_150930_(recipe.m_41720_()) && slot.areShareTagsEqual(recipe);
    }

    private boolean validateFusion(ItemStack input, ItemStack inputSlot, ItemStack output, ItemStack outputSlot) {
        return this.slotMatches(inputSlot, input) && this.slotMatches(outputSlot, output) && outputSlot.m_41613_() == output.m_41613_();
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output, ItemStack result) {
        return output.m_41619_() || output.m_150930_(result.m_41720_()) && output.areShareTagsEqual(result);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack output, int addedCount) {
        return output.m_41613_() + addedCount <= output.m_41741_();
    }

    private Optional<PlortPressingRecipe> getCurrentRecipe() {
        SimpleContainer newInventory = new SimpleContainer(2);
        newInventory.m_6836_(0, this.topInventory.getStackInSlot(0));
        newInventory.m_6836_(1, this.bottomInventory.getStackInSlot(0));
        return this.f_58857_.m_7465_().m_44015_((RecipeType)PlortPressingRecipe.Type.INSTANCE, (Container)newInventory, this.f_58857_);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag splendidData = new CompoundTag();
        splendidData.m_128365_("TopInventory", (Tag)this.topInventory.serializeNBT());
        splendidData.m_128365_("BottomInventory", (Tag)this.bottomInventory.serializeNBT());
        splendidData.m_128405_("Progress", this.progress);
        tag.m_128365_("splendid_slimes", (Tag)splendidData);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        CompoundTag splendidData = pTag.m_128469_("splendid_slimes");
        if (splendidData.m_128425_("TopInventory", 10)) {
            this.topInventory.deserializeNBT(splendidData.m_128469_("TopInventory"));
        }
        if (splendidData.m_128425_("BottomInventory", 10)) {
            this.bottomInventory.deserializeNBT(splendidData.m_128469_("BottomInventory"));
        }
        this.progress = splendidData.m_128451_("Progress");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.splendid_slimes.plort_press");
    }
}

