/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.blockentity;

import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import io.github.chakyl.splendidslimes.block.SlimeFeederBlock;
import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.registry.ModElements;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class SlimeFeederBlockEntity
extends RandomizableContainerBlockEntity
implements TickingBlockEntity {
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    public SlimeFeederBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModElements.BlockEntities.SLIME_FEEDER.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (level.m_46467_() % 200L == 0L) {
            Boolean hasItems = false;
            for (ItemStack slotItem : this.contents) {
                if (slotItem.m_41619_()) continue;
                hasItems = true;
                break;
            }
            if (state.m_61143_((Property)SlimeFeederBlock.HAS_FOOD) != hasItems) {
                BlockState newState = (BlockState)state.m_61124_((Property)SlimeFeederBlock.HAS_FOOD, (Comparable)hasItems);
                level.m_46597_(pos, newState);
            }
            if (hasItems.booleanValue()) {
                List nearbySlimes = level.m_45976_(SplendidSlime.class, new AABB(this.f_58858_).m_82400_(6.0));
                block1: for (SplendidSlime slime : nearbySlimes) {
                    boolean handlePicky = slime.hasTrait("picky") && slime.isLargo();
                    for (ItemStack slotItem : this.contents) {
                        if (!slime.m_7243_(slotItem)) continue;
                        boolean isPrimary = slime.isPrimaryFood(slotItem);
                        if (handlePicky && (slime.getLastAte() == 0 && isPrimary || slime.getLastAte() == 1 && !isPrimary)) continue;
                        slime.handleFeed(slime.isFavoriteFood(slotItem.m_41720_()), slotItem);
                        slotItem.m_41774_(1);
                        continue block1;
                    }
                }
            }
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.contents);
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.splendid_slimes.slime_feeder");
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compound)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.contents);
        }
    }

    public int m_6643_() {
        return 9;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.contents;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.contents = itemsIn;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new ChestMenu(MenuType.f_39957_, id, player, (Container)this, 1);
    }
}

