/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import io.github.chakyl.splendidslimes.item.HatItem;
import io.github.chakyl.splendidslimes.item.PlortItem;
import io.github.chakyl.splendidslimes.item.SlimeInventoryItem;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.util.SlimeBreedRegistration;
import io.github.chakyl.splendidslimes.util.SlimeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public record SlimeBreed(String breed, MutableComponent name, ItemStack hat, float hatScale, float hatXOffset, float hatYOffset, float hatZOffset, ItemStack particle, MutableComponent diet, List<Object> foods, ItemStack favoriteFood, List<EntityType<? extends LivingEntity>> entities, EntityType<? extends LivingEntity> favoriteEntity, List<EntityType<? extends LivingEntity>> hostileToEntities, List<String> traits, List<MobEffectInstance> innateEffects, SimpleParticleType emitEffectParticle, List<MobEffectInstance> positiveEmitEffects, List<MobEffectInstance> negativeEmitEffects, List<String> positiveCommands, List<String> negativeCommands, List<String> attackCommands) implements CodecProvider<SlimeBreed>
{
    public static final Codec<SlimeBreed> CODEC = new SlimeBreedCodec();
    public static final List<String> POSSIBLE_TRAITS = Arrays.asList("aquatic", "defiant", "dominant", "recessive", "explosive", "feral", "flaming", "floating", "foodporting", "handy", "inverse", "largoless", "moody", "nuclear", "picky", "photosynthesizing", "putrid", "spiky", "weeping");

    public SlimeBreed(SlimeBreed other) {
        this(other.breed, other.name, other.hat, other.hatScale, other.hatXOffset, other.hatYOffset, other.hatZOffset, other.particle, other.diet, other.foods, other.favoriteFood, other.entities, other.favoriteEntity, other.hostileToEntities, other.traits, other.innateEffects, other.emitEffectParticle, other.positiveEmitEffects, other.negativeEmitEffects, other.positiveCommands, other.negativeCommands, other.attackCommands);
    }

    public int getColor() {
        return this.name.m_7383_().m_131135_().m_131265_();
    }

    public ItemStack getSlimeItem() {
        ItemStack stack = new ItemStack((ItemLike)ModElements.Items.SLIME_ITEM.get());
        SlimeInventoryItem.setStoredSlime(stack, this);
        return stack;
    }

    public ItemStack getPlort() {
        ItemStack stack = new ItemStack((ItemLike)ModElements.Items.PLORT.get());
        PlortItem.setStoredPlort(stack, this);
        return stack;
    }

    public SlimeBreed validate(ResourceLocation key) {
        Preconditions.checkNotNull((Object)this.breed, (Object)"Invalid slime breed id!");
        Preconditions.checkNotNull((Object)this.name, (Object)"Invalid slime name!");
        Preconditions.checkNotNull((Object)this.diet, (Object)"Invalid slime diet!");
        Preconditions.checkNotNull((Object)this.name.m_7383_().m_131135_(), (Object)"Invalid entity name color!");
        if (this.traits != null) {
            this.traits.forEach(trait -> {
                if (!POSSIBLE_TRAITS.contains(trait.replace("\"", ""))) {
                    throw new NullPointerException("Slime given trait " + trait + " that doesn't exist! Possible values: " + String.valueOf(POSSIBLE_TRAITS));
                }
            });
        }
        return this;
    }

    public Codec<? extends SlimeBreed> getCodec() {
        return CODEC;
    }

    public static class SlimeBreedCodec
    implements Codec<SlimeBreed> {
        public <T> DataResult<T> encode(SlimeBreed input, DynamicOps<T> ops, T prefix) {
            JsonObject obj = new JsonObject();
            ResourceLocation key = new ResourceLocation("splendid_slimes", input.breed);
            obj.addProperty("breed", input.breed);
            obj.addProperty("name", ((TranslatableContents)input.name.m_214077_()).m_237508_());
            obj.add("hat", ItemAdapter.ITEM_READER.toJsonTree((Object)input.hat));
            obj.addProperty("hat_scale", (Number)Float.valueOf(input.hatScale));
            obj.addProperty("hat_x_offset", (Number)Float.valueOf(input.hatXOffset));
            obj.addProperty("hat_y_offset", (Number)Float.valueOf(input.hatYOffset));
            obj.addProperty("hat_z_offset", (Number)Float.valueOf(input.hatZOffset));
            obj.add("particle", ItemAdapter.ITEM_READER.toJsonTree((Object)input.particle));
            obj.addProperty("diet", ((TranslatableContents)input.diet.m_214077_()).m_237508_());
            obj.addProperty("color", input.name.m_7383_().m_131135_().m_131274_());
            JsonArray foods = new JsonArray();
            obj.add("foods", (JsonElement)foods);
            for (Object object : input.foods) {
                if (object.getClass() == ItemStack.class) {
                    JsonElement jsonElement = ItemAdapter.ITEM_READER.toJsonTree(object);
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    ResourceLocation resourceLocation = new ResourceLocation(jsonObject.get("item").getAsString());
                    if (!"minecraft".equals(resourceLocation.m_135827_()) && !key.m_135827_().equals(resourceLocation.m_135827_())) {
                        jsonObject.addProperty("optional", Boolean.valueOf(true));
                    }
                    foods.add((JsonElement)jsonObject);
                }
                if (object.getClass() != TagKey.class) continue;
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("tag", ((TagKey)object).f_203868_().toString());
                foods.add((JsonElement)jsonObject);
            }
            obj.add("favorite_food", ItemAdapter.ITEM_READER.toJsonTree((Object)input.favoriteFood));
            obj.add("entities", ItemAdapter.ITEM_READER.toJsonTree(input.entities.stream().map(EntityType::m_20613_).toList()));
            obj.addProperty("favorite_entity", EntityType.m_20613_(input.favoriteEntity).toString());
            obj.add("hostile_to_entities", ItemAdapter.ITEM_READER.toJsonTree(input.hostileToEntities.stream().map(EntityType::m_20613_).toList()));
            JsonArray traits = new JsonArray();
            obj.add("traits", (JsonElement)traits);
            for (String string : input.traits) {
                traits.add(string.replace("\"", ""));
            }
            JsonArray jsonArray = new JsonArray();
            obj.add("innate_effects", (JsonElement)jsonArray);
            for (MobEffectInstance mobEffectInstance : input.innateEffects) {
                jsonArray.add((JsonElement)SlimeBreedRegistration.getEffectJson(mobEffectInstance, true));
            }
            obj.addProperty("emit_effect_particle", SlimeBreedRegistration.getParticleTypeJson(input.emitEffectParticle));
            JsonArray jsonArray2 = new JsonArray();
            obj.add("positive_emit_effects", (JsonElement)jsonArray2);
            for (MobEffectInstance mobEffectInstance : input.positiveEmitEffects) {
                jsonArray2.add((JsonElement)SlimeBreedRegistration.getEffectJson(mobEffectInstance, false));
            }
            JsonArray jsonArray3 = new JsonArray();
            obj.add("negative_emit_effects", (JsonElement)jsonArray3);
            for (MobEffectInstance mobEffectInstance : input.negativeEmitEffects) {
                jsonArray3.add((JsonElement)SlimeBreedRegistration.getEffectJson(mobEffectInstance, false));
            }
            JsonArray jsonArray4 = new JsonArray();
            obj.add("positive_commands", (JsonElement)jsonArray4);
            for (String string : input.positiveCommands) {
                jsonArray4.add(string);
            }
            JsonArray jsonArray5 = new JsonArray();
            obj.add("negative_commands", (JsonElement)jsonArray5);
            for (String command : input.negativeCommands) {
                jsonArray5.add(command);
            }
            JsonArray jsonArray6 = new JsonArray();
            obj.add("attack_commands", (JsonElement)jsonArray6);
            for (String command : input.attackCommands) {
                jsonArray6.add(command);
            }
            return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)obj));
        }

        public <T> DataResult<Pair<SlimeBreed, T>> decode(DynamicOps<T> ops, T input) {
            String favoriteEntityStr;
            JsonObject obj = ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject();
            String breed = GsonHelper.m_13906_((JsonObject)obj, (String)"breed");
            MutableComponent name = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"name"));
            ItemStack hat = ((HatItem)((Object)ModElements.Items.HAT.get())).m_7968_();
            if (obj.has("hat")) {
                hat = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("hat"), ItemStack.class);
            }
            float hatScale = 1.0f;
            if (obj.has("hat_scale")) {
                hatScale = GsonHelper.m_13915_((JsonObject)obj, (String)"hat_scale");
            }
            float hatXOffset = 0.0f;
            if (obj.has("hat_x_offset")) {
                hatXOffset = GsonHelper.m_13915_((JsonObject)obj, (String)"hat_x_offset");
            }
            float hatYOffset = -1.0f;
            if (obj.has("hat_y_offset")) {
                hatYOffset = GsonHelper.m_13915_((JsonObject)obj, (String)"hat_y_offset");
            }
            float hatZOffset = -0.05f;
            if (obj.has("hat_z_offset")) {
                hatZOffset = GsonHelper.m_13915_((JsonObject)obj, (String)"hat_z_offset");
            }
            ItemStack particle = new ItemStack((ItemLike)Items.f_41852_);
            if (obj.has("particle")) {
                particle = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("particle"), ItemStack.class);
            }
            MutableComponent diet = Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"diet"));
            if (obj.has("color")) {
                String colorStr = GsonHelper.m_13906_((JsonObject)obj, (String)"color");
                TextColor color = TextColor.m_131268_((String)colorStr);
                name = name.m_130948_(Style.f_131099_.m_131148_(color));
            } else {
                name.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
            }
            ArrayList<Object> foods = new ArrayList<Object>();
            if (obj.has("foods")) {
                JsonArray parsedFood = GsonHelper.m_13933_((JsonObject)obj, (String)"foods");
                for (Object e : parsedFood) {
                    if (e.getAsJsonObject().has("item")) {
                        foods.add(ItemAdapter.ITEM_READER.fromJson((JsonElement)e.getAsJsonObject(), ItemStack.class));
                        continue;
                    }
                    if (!e.getAsJsonObject().has("tag")) continue;
                    foods.add(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(e.getAsJsonObject().get("tag").getAsString())));
                }
            }
            ItemStack favoriteFood = new ItemStack((ItemLike)Items.f_41852_);
            if (obj.has("favorite_food")) {
                favoriteFood = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("favorite_food"), ItemStack.class);
            }
            ArrayList<EntityType<? extends LivingEntity>> entities = new ArrayList<EntityType<? extends LivingEntity>>();
            if (obj.has("entities")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"entities")) {
                    Iterator st = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.getAsString()));
                    if (st == EntityType.f_20510_ && !"minecraft:pig".equals(json.getAsString())) continue;
                    entities.add((EntityType<? extends LivingEntity>)st);
                }
            }
            EntityType favoriteEntity = null;
            if (obj.has("favorite_entity") && (favoriteEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(favoriteEntityStr = GsonHelper.m_13906_((JsonObject)obj, (String)"favorite_entity")))) == EntityType.f_20510_ && !"minecraft:pig".equals(favoriteEntityStr)) {
                throw new JsonParseException("Slime has invalid favorite entity type " + favoriteEntityStr);
            }
            ArrayList<EntityType<? extends LivingEntity>> hostileToEntitites = new ArrayList<EntityType<? extends LivingEntity>>();
            if (obj.has("hostile_to_entities")) {
                for (Object json : GsonHelper.m_13933_((JsonObject)obj, (String)"hostile_to_entities")) {
                    EntityType st = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.getAsString()));
                    if (st == EntityType.f_20510_ && !"minecraft:pig".equals(json.getAsString())) continue;
                    hostileToEntitites.add(st);
                }
            }
            ArrayList<String> traits = new ArrayList<String>();
            if (obj.has("traits")) {
                for (Object json : GsonHelper.m_13933_((JsonObject)obj, (String)"traits")) {
                    traits.add(String.valueOf(json).replace("\"", ""));
                }
            }
            ArrayList<MobEffectInstance> innateEffects = new ArrayList<MobEffectInstance>();
            if (obj.has("innate_effects")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"innate_effects")) {
                    innateEffects.add(SlimeBreedRegistration.getEffectFromJson(json, true));
                }
            }
            SimpleParticleType emitEffectParticleType = ParticleTypes.f_123806_;
            if (obj.has("emit_effect_particle")) {
                emitEffectParticleType = SlimeBreedRegistration.getParticleTypeFromJson(obj.get("emit_effect_particle"));
            }
            ArrayList<MobEffectInstance> positiveEmitEffects = new ArrayList<MobEffectInstance>();
            if (obj.has("positive_emit_effects")) {
                for (Object json : GsonHelper.m_13933_((JsonObject)obj, (String)"positive_emit_effects")) {
                    positiveEmitEffects.add(SlimeBreedRegistration.getEffectFromJson((JsonElement)json, false));
                }
            }
            ArrayList<MobEffectInstance> negativeEmitEffects = new ArrayList<MobEffectInstance>();
            if (obj.has("negative_emit_effects")) {
                for (Object json : GsonHelper.m_13933_((JsonObject)obj, (String)"negative_emit_effects")) {
                    negativeEmitEffects.add(SlimeBreedRegistration.getEffectFromJson((JsonElement)json, false));
                }
            }
            ArrayList<String> positiveCommands = new ArrayList<String>();
            if (obj.has("positive_commands")) {
                for (Object json : GsonHelper.m_13933_((JsonObject)obj, (String)"positive_commands")) {
                    positiveCommands.add(SlimeData.parseCommand(String.valueOf(json)));
                }
            }
            ArrayList<String> negativeCommands = new ArrayList<String>();
            if (obj.has("negative_commands")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"negative_commands")) {
                    positiveCommands.add(SlimeData.parseCommand(String.valueOf(json)));
                }
            }
            ArrayList<String> attackCommands = new ArrayList<String>();
            if (obj.has("attack_commands")) {
                for (JsonElement json : GsonHelper.m_13933_((JsonObject)obj, (String)"attack_commands")) {
                    attackCommands.add(SlimeData.parseCommand(String.valueOf(json)));
                }
            }
            return DataResult.success((Object)Pair.of((Object)new SlimeBreed(breed, name, hat, hatScale, hatXOffset, hatYOffset, hatZOffset, particle, diet, foods, favoriteFood, entities, (EntityType<? extends LivingEntity>)favoriteEntity, hostileToEntitites, traits, innateEffects, emitEffectParticleType, positiveEmitEffects, negativeEmitEffects, positiveCommands, negativeCommands, attackCommands), input));
        }
    }
}

