/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.chakyl.splendidslimes.registry.ModElements;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlortPressRecipeBuilder {
    private final String breed;

    private PlortPressRecipeBuilder(String breed) {
        this.breed = breed;
    }

    public static PlortPressRecipeBuilder pressRecipe(String breed) {
        return new PlortPressRecipeBuilder(breed);
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, "splendid_slimes:plort_pressing/" + this.breed);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ModElements.Items.SLIME_HEART.getId();
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Cooking Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.breed));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String breed;
        private final int inputCount = 32;

        public Result(ResourceLocation idIn, String breed) {
            this.id = idIn;
            this.breed = breed;
        }

        public void m_7917_(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            JsonObject inputIngredient = new JsonObject();
            JsonObject inputNbt = new JsonObject();
            JsonObject plortId = new JsonObject();
            plortId.addProperty("id", "splendid_slimes:" + this.breed);
            inputNbt.add("plort", (JsonElement)plortId);
            inputIngredient.addProperty("item", "splendid_slimes:plort");
            inputIngredient.add("nbt", (JsonElement)inputNbt);
            inputIngredient.addProperty("count", (Number)this.inputCount);
            json.add("ingredient", (JsonElement)inputIngredient);
            JsonObject result = new JsonObject();
            JsonObject outputNbt = new JsonObject();
            JsonObject slimeId = new JsonObject();
            slimeId.addProperty("id", "splendid_slimes:" + this.breed);
            outputNbt.add("slime", (JsonElement)slimeId);
            result.addProperty("item", "splendid_slimes:slime_heart");
            result.add("nbt", (JsonElement)outputNbt);
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModElements.Recipes.PLORT_PRESSING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

