/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item.ItemProjectile;

import io.github.chakyl.splendidslimes.registry.ModElements;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class ItemProjectileEntity
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    protected ItemStack stack = ItemStack.f_41583_;

    public ItemProjectileEntity(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super(type, world);
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public void setItem(ItemStack stack) {
        this.stack = stack;
    }

    public void m_7378_(CompoundTag nbt) {
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        super.m_7378_(nbt);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("Item", (Tag)this.stack.serializeNBT());
        super.m_7380_(nbt);
    }

    public void m_8119_() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0).m_82490_(1.0));
        super.m_8119_();
    }

    protected float m_6884_() {
        return 1.0f;
    }

    protected boolean m_5931_() {
        return false;
    }

    protected void m_5790_(EntityHitResult ray) {
        Vec3 appliedMotion;
        boolean onServer;
        super.m_5790_(ray);
        Entity target = ray.m_82443_();
        float knockback = 1.0f;
        Entity owner = this.m_19749_();
        if (!target.m_6084_()) {
            return;
        }
        if (target instanceof WitherBoss && ((WitherBoss)target).m_7090_()) {
            return;
        }
        boolean bl = onServer = !this.m_9236_().f_46443_;
        if (target.m_6095_() == EntityType.f_20566_) {
            return;
        }
        if (!(target instanceof LivingEntity)) {
            this.recoverItem();
            this.m_6074_();
            return;
        }
        LivingEntity livingentity = (LivingEntity)target;
        if (onServer && (appliedMotion = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
            livingentity.m_5997_(appliedMotion.f_82479_, 0.1, appliedMotion.f_82481_);
        }
        if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer && !this.m_20067_()) {
            ((ServerPlayer)owner).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
        }
        this.recoverItem();
        this.m_6074_();
    }

    private void recoverItem() {
        if (!this.stack.m_41619_()) {
            this.m_19983_(ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)1));
        }
    }

    protected void m_8060_(BlockHitResult ray) {
        if (!this.m_9236_().m_5776_() && this.getItem().m_41720_() == ModElements.Items.ROCKET_POD.get()) {
            BlockPos hitBlock = ray.m_82425_();
            List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0));
            for (LivingEntity entity : nearbyEntities) {
                Vec3 appliedMotion = this.m_20184_().m_82542_(-1.0, 0.0, -1.0).m_82541_().m_82490_(2.4);
                if (entity instanceof ServerPlayer) {
                    ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundExplodePacket((double)hitBlock.m_123341_(), (double)hitBlock.m_123342_(), (double)hitBlock.m_123343_(), 4.0f, new ArrayList(), new Vec3(appliedMotion.f_82479_, 1.5, appliedMotion.f_82481_)));
                }
                if (!(appliedMotion.m_82556_() > 0.0)) continue;
                entity.m_5997_(appliedMotion.f_82479_, 1.0, appliedMotion.f_82481_);
            }
        } else {
            this.recoverItem();
        }
        super.m_8060_(ray);
        this.m_6074_();
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.m_20699_(0.25f, 0.25f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        buffer.m_130079_(compound);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
    }
}

