/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.data.SlimeBreedRegistry;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class SlimeSpawnEggItem
extends ForgeSpawnEggItem
implements ITabFiller {
    public static final String SLIME = "EntityTag";
    public static final String ID = "Breed";
    public static final String DATA = "data";

    public SlimeSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        super(type, backgroundColor, highlightColor, props);
    }

    public void fillItemCategory(CreativeModeTab tab, CreativeModeTab.Output output) {
        SlimeBreedRegistry.INSTANCE.getKeys().stream().sorted().forEach(key -> {
            ItemStack s = new ItemStack((ItemLike)this);
            SlimeSpawnEggItem.setStoredSlime(s, key);
            output.m_246342_(s);
        });
    }

    public Component m_7626_(ItemStack pStack) {
        DynamicHolder<SlimeBreed> slime = SlimeSpawnEggItem.getSlime(pStack);
        MutableComponent slimeName = !slime.isBound() ? Component.m_237113_((String)"BROKEN").m_130940_(ChatFormatting.OBFUSCATED) : ((SlimeBreed)slime.get()).name();
        return Component.m_237110_((String)this.m_5671_(pStack), (Object[])new Object[]{slimeName});
    }

    public static DynamicHolder<SlimeBreed> getSlime(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(SLIME);
        if (stack.m_41619_() || tag == null || !tag.m_128441_(ID)) {
            return SlimeBreedRegistry.INSTANCE.emptyHolder();
        }
        return SlimeBreedRegistry.INSTANCE.holder(new ResourceLocation(tag.m_128461_(ID)));
    }

    public static void setStoredSlime(ItemStack stack, ResourceLocation slime) {
        stack.m_41749_(SLIME);
        stack.m_41698_(SLIME).m_128359_(ID, slime.toString());
    }

    @Nonnull
    public EntityType<?> m_43228_(CompoundTag compound) {
        CompoundTag entityTag;
        if (compound != null && compound.m_128425_(SLIME, 10) && (entityTag = compound.m_128469_(SLIME)).m_128425_(ID, 8)) {
            return EntityType.m_20632_((String)entityTag.m_128461_(ID)).orElse(this.getDefaultType());
        }
        return this.getDefaultType();
    }
}

