/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item;

import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.item.ItemProjectile.ItemProjectileEntity;
import io.github.chakyl.splendidslimes.item.SlimeInventoryItem;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.tag.SplendidSlimesItemTags;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SlimeVac
extends Item {
    public static final String NBT_MODE = "Mode";
    private static final int RANGE = 10;
    private static final double ANGLE = Math.cos(0.7853981633974483);

    public SlimeVac(Item.Properties pProperties) {
        super(pProperties);
    }

    public static VacMode getMode(ItemStack stack) {
        if (stack.m_41782_()) {
            return VacMode.valueOf(stack.m_41784_().m_128461_(NBT_MODE));
        }
        return VacMode.BOTH;
    }

    public static void setMode(ItemStack stack, VacMode mode) {
        stack.m_41784_().m_128359_(NBT_MODE, mode.name());
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.m_7836_(pStack, pLevel, pPlayer);
        this.initNbt(pStack);
    }

    private ItemStack initNbt(ItemStack stack) {
        stack.m_41784_().m_128359_(NBT_MODE, VacMode.BOTH.name());
        return stack;
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        list.add((Component)Component.m_237115_((String)"info.splendid_slimes.slime_vac").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237110_((String)"info.splendid_slimes.slime_vac.mode", (Object[])new Object[]{SlimeVac.getMode(pStack).name()}));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (player.m_6047_()) {
            Class<SplendidSlime> entityClass = SplendidSlime.class;
            if (SlimeVac.getMode(handStack) == VacMode.ITEM) {
                entityClass = ItemEntity.class;
            }
            ArrayList entities = (ArrayList)level.m_6443_(entityClass, new AABB(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82400_(10.0), EntitySelector.f_20402_);
            if (SlimeVac.getMode(handStack) == VacMode.BOTH) {
                entities.addAll(level.m_6443_(ItemEntity.class, new AABB(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82400_(10.0), EntitySelector.f_20402_));
            }
            Vec3 look = player.m_20154_().m_82490_(10.0);
            Vec3 playPos = player.m_20182_();
            entities.removeIf(e -> {
                Vec3 ePos = e.m_20182_().m_82546_(playPos);
                return ePos.m_82553_() >= 10.0 || ePos.m_82526_(look) / (ePos.m_82553_() * look.m_82553_()) <= ANGLE;
            });
            for (Entity entity : entities) {
                Vec3 motVec = player.m_20182_().m_82546_(entity.m_20182_()).m_82490_(0.25);
                entity.m_5997_(motVec.f_82479_, motVec.f_82480_ + 0.2, motVec.f_82481_);
            }
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        Vec3 lookVec = player.m_20154_();
        Vec3 motion = lookVec.m_82541_().m_82490_(2.0).m_82490_(1.5);
        InteractionHand inverseHand = InteractionHand.OFF_HAND;
        if (hand == InteractionHand.OFF_HAND) {
            inverseHand = InteractionHand.MAIN_HAND;
        }
        ItemStack itemStackToLaunch = player.m_21120_(inverseHand);
        boolean slimeFired = false;
        if (itemStackToLaunch != ItemStack.f_41583_ && itemStackToLaunch.m_204117_(SplendidSlimesItemTags.SLIME_VAC_FIREABLE)) {
            Object projectile;
            Item itemToLaunch = itemStackToLaunch.m_41720_();
            Vec3 barrelPos = SlimeVac.getShootLocVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)0.45f, -0.5, 1.0));
            if (itemToLaunch == ModElements.Items.SLIME_ITEM.get()) {
                projectile = SlimeInventoryItem.getSlimeFromItem(itemStackToLaunch.m_41783_().m_128469_("entity"), itemStackToLaunch.m_41783_().m_128469_("slime"), level);
                projectile.m_20334_(0.0, 0.0, 0.0);
                slimeFired = true;
            } else if (itemToLaunch == Items.f_42412_.m_5456_()) {
                projectile = EntityType.f_20548_.m_20615_(level);
                ((Arrow)projectile).m_5602_((Entity)player);
            } else if (itemToLaunch == Items.f_41996_.m_5456_()) {
                projectile = EntityType.f_20515_.m_20615_(level);
            } else {
                projectile = new ItemProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModElements.Entities.ITEM_PROJECTILE.get()), level);
                ((ItemProjectileEntity)((Object)projectile)).setItem(itemStackToLaunch.m_41777_());
                barrelPos = SlimeVac.getShootLocVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)0.65f, -1.0, 2.0));
            }
            if (projectile == null) {
                return InteractionResultHolder.m_19098_((Object)handStack);
            }
            Vec3 splitMotion = motion;
            projectile.m_6034_(barrelPos.f_82479_, barrelPos.f_82480_, barrelPos.f_82481_);
            projectile.m_20256_(splitMotion);
            level.m_7967_(projectile);
            projectile.m_5496_(SoundEvents.f_11752_, 1.0f, 0.9f);
            if (slimeFired) {
                player.m_21008_(inverseHand, ItemStack.f_41583_);
            } else if (!player.m_7500_()) {
                player.m_21120_(inverseHand).m_41774_(1);
            }
            player.m_36335_().m_41524_((Item)ModElements.Items.SLIME_VAC.get(), 4);
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        return InteractionResultHolder.m_19098_((Object)handStack);
    }

    public static Vec3 getShootLocVec(Player player, boolean mainHand, Vec3 rightHandForward) {
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        float yaw = (float)((double)(player.m_146908_() / -180.0f) * Math.PI);
        float pitch = (float)((double)(player.m_146909_() / -180.0f) * Math.PI);
        int flip = mainHand == (player.m_5737_() == HumanoidArm.RIGHT) ? -1 : 1;
        Vec3 barrelPosNoTransform = new Vec3((double)flip * rightHandForward.f_82479_, rightHandForward.f_82480_, rightHandForward.f_82481_);
        Vec3 barrelPos = start.m_82549_(barrelPosNoTransform.m_82496_(pitch).m_82524_(yaw));
        return barrelPos;
    }

    public static enum VacMode {
        ITEM,
        SLIME,
        BOTH;

    }
}

