/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.blockentity;

import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import io.github.chakyl.splendidslimes.SlimyConfig;
import io.github.chakyl.splendidslimes.block.PlortRippitBlock;
import io.github.chakyl.splendidslimes.block.SlimeIncubatorBlock;
import io.github.chakyl.splendidslimes.entity.SlimeEntityBase;
import io.github.chakyl.splendidslimes.registry.ModElements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SlimeIncubatorBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    private int INCUBATION_TIME = SlimyConfig.incubationTime;
    protected int progress = 0;
    protected String slimeType = "";

    public SlimeIncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModElements.BlockEntities.SLIME_INCUBATOR.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.slimeType.isEmpty()) {
            if (this.progress >= this.INCUBATION_TIME) {
                SlimeEntityBase birthSlime = (SlimeEntityBase)((EntityType)ModElements.Entities.SPLENDID_SLIME.get()).m_20615_(level);
                birthSlime.setSlimeBreed(this.slimeType);
                birthSlime.m_7839_(1, true);
                birthSlime.m_21530_();
                BlockPos facingPos = pos.m_121945_((Direction)state.m_61143_((Property)PlortRippitBlock.f_54117_));
                birthSlime.m_7678_((double)facingPos.m_123341_() + 0.25, facingPos.m_123342_(), (double)facingPos.m_123343_() + 0.25, level.f_46441_.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)birthSlime);
                BlockState newState = (BlockState)state.m_61124_((Property)SlimeIncubatorBlock.WORKING, (Comparable)Boolean.valueOf(false));
                level.m_46597_(pos, newState);
                this.slimeType = "";
                this.m_6596_();
            } else {
                ++this.progress;
            }
        } else {
            this.progress = 0;
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128359_("slimeType", this.slimeType);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        this.slimeType = tag.m_128461_("slimeType");
    }

    public void setSlimeType(String type) {
        this.slimeType = type;
    }

    public String getSlimeType() {
        return this.slimeType;
    }

    public int getProgress() {
        return this.progress;
    }
}

