/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.item;

import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import io.github.chakyl.splendidslimes.item.ItemProjectile.ItemProjectileEntity;
import io.github.chakyl.splendidslimes.item.SlimeInventoryItem;
import io.github.chakyl.splendidslimes.registry.ModElements;
import io.github.chakyl.splendidslimes.tag.SplendidSlimesItemTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SlimeVac
extends Item {
    public static final String NBT_MODE = "Mode";
    private static final int RANGE = 10;
    private static final double ANGLE = Math.cos(0.7853981633974483);
    private UUID jammedLargo = null;

    public SlimeVac(Item.Properties pProperties) {
        super(pProperties);
    }

    public static VacMode getMode(ItemStack stack) {
        if (stack.m_41782_()) {
            return VacMode.valueOf(stack.m_41784_().m_128461_(NBT_MODE));
        }
        return VacMode.BOTH;
    }

    public static void setMode(ItemStack stack, VacMode mode) {
        stack.m_41784_().m_128359_(NBT_MODE, mode.name());
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        super.m_7836_(pStack, pLevel, pPlayer);
        this.initNbt(pStack);
    }

    private ItemStack initNbt(ItemStack stack) {
        stack.m_41784_().m_128359_(NBT_MODE, VacMode.BOTH.name());
        return stack;
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        list.add((Component)Component.m_237115_((String)"info.splendid_slimes.slime_vac").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237110_((String)"info.splendid_slimes.slime_vac.mode", (Object[])new Object[]{SlimeVac.getMode(pStack).name()}));
    }

    private void suckParticles(Level level, Player player) {
        if (!level.f_46443_) {
            Vec3 startPos = player.m_146892_().m_82520_(0.0, (double)-0.2f, -0.5);
            Vec3 lookDirection = player.m_20252_(1.0f);
            Vec3 endPos = startPos.m_82520_(lookDirection.f_82479_ * 10.0, lookDirection.f_82480_ * 10.0, lookDirection.f_82481_ * 10.0);
            BlockHitResult rayTraceResult = level.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (rayTraceResult instanceof BlockHitResult) {
                BlockHitResult blockHit = rayTraceResult;
                endPos = blockHit.m_82450_();
            }
            for (int i = 0; i < 20; ++i) {
                double t = (double)i / 10.0 * 2.0;
                double x = startPos.f_82479_ + (endPos.f_82479_ - startPos.f_82479_) * t;
                double y = startPos.f_82480_ + (endPos.f_82480_ - startPos.f_82480_) * t;
                double z = startPos.f_82481_ + (endPos.f_82481_ - startPos.f_82481_) * t;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
    }

    private SplendidSlime getJammedLargo(Level level, Player player) {
        Class<SplendidSlime> entityClass = SplendidSlime.class;
        ArrayList entities = (ArrayList)level.m_6443_(entityClass, new AABB(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82400_(2.0), EntitySelector.f_20402_);
        if (entities.isEmpty()) {
            this.jammedLargo = null;
            return null;
        }
        for (Entity entity : entities) {
            if (!entity.m_20148_().equals(this.jammedLargo)) continue;
            return (SplendidSlime)entity;
        }
        return null;
    }

    private void moveLargo(Level level, Player player) {
        SplendidSlime largo = this.getJammedLargo(level, player);
        if (largo != null) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1, true, false));
            Vec3 target3 = new Vec3(player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_()).m_82549_(player.m_20154_().m_82490_(10.0)).m_82520_(0.0, 0.5, 0.0);
            Vec3 entityVector = new Vec3(largo.m_20185_(), largo.m_20186_() + (double)(largo.m_20206_() / 2.0f), largo.m_20189_());
            Vec3 finalVector = target3.m_82546_(entityVector);
            if (finalVector.m_82553_() > 1.0) {
                finalVector = finalVector.m_82541_();
            }
            largo.m_20256_(finalVector.m_82490_(0.3333333134651184));
            Vec3 motVec = player.m_20182_().m_82546_(largo.m_20182_()).m_82490_(0.5);
            largo.m_5997_(motVec.f_82479_, motVec.f_82480_ + 0.2, motVec.f_82481_);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (this.jammedLargo != null) {
            this.moveLargo(level, player);
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        if (player.m_6047_()) {
            Class<SplendidSlime> entityClass = SplendidSlime.class;
            if (SlimeVac.getMode(handStack) == VacMode.ITEM) {
                entityClass = ItemEntity.class;
            }
            ArrayList entities = (ArrayList)level.m_6443_(entityClass, new AABB(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82400_(10.0), EntitySelector.f_20402_);
            if (SlimeVac.getMode(handStack) == VacMode.BOTH) {
                entities.addAll(level.m_6443_(ItemEntity.class, new AABB(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82400_(10.0), EntitySelector.f_20402_));
            }
            Vec3 look = player.m_20154_().m_82490_(10.0);
            Vec3 playPos = player.m_20182_();
            entities.removeIf(e -> {
                Vec3 ePos = e.m_20182_().m_82546_(playPos);
                return ePos.m_82553_() >= 10.0 || ePos.m_82526_(look) / (ePos.m_82553_() * look.m_82553_()) <= ANGLE;
            });
            for (Entity entity : entities) {
                if (entity.getClass().equals(entityClass) && entity.m_20270_((Entity)player) < 2.0f) {
                    if (this.jammedLargo != null || !((SplendidSlime)entity).isLargo()) continue;
                    this.jammedLargo = entity.m_20148_();
                    entity.m_5496_(SoundEvents.f_11752_, 1.0f, 0.8f);
                    continue;
                }
                Vec3 motVec = player.m_20182_().m_82546_(entity.m_20182_()).m_82490_(0.25);
                entity.m_5997_(motVec.f_82479_, motVec.f_82480_ + 0.2, motVec.f_82481_);
            }
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        Vec3 lookVec = player.m_20154_();
        Vec3 motion = lookVec.m_82541_().m_82490_(2.0).m_82490_(1.5);
        InteractionHand inverseHand = InteractionHand.OFF_HAND;
        if (hand == InteractionHand.OFF_HAND) {
            inverseHand = InteractionHand.MAIN_HAND;
        }
        ItemStack itemStackToLaunch = player.m_21120_(inverseHand);
        boolean slimeFired = false;
        if (itemStackToLaunch != ItemStack.f_41583_ && itemStackToLaunch.m_204117_(SplendidSlimesItemTags.SLIME_VAC_FIREABLE)) {
            Object projectile;
            Item itemToLaunch = itemStackToLaunch.m_41720_();
            Vec3 barrelPos = SlimeVac.getShootLocVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)0.45f, -0.5, 1.0));
            if (itemToLaunch == ModElements.Items.SLIME_ITEM.get()) {
                projectile = SlimeInventoryItem.getSlimeFromItem(itemStackToLaunch.m_41783_().m_128469_("entity"), itemStackToLaunch.m_41783_().m_128469_("slime"), level);
                projectile.m_20334_(0.0, 0.0, 0.0);
                slimeFired = true;
            } else if (itemToLaunch == Items.f_42412_.m_5456_()) {
                projectile = EntityType.f_20548_.m_20615_(level);
                ((Arrow)projectile).m_5602_((Entity)player);
            } else if (itemToLaunch == Items.f_41996_.m_5456_()) {
                projectile = EntityType.f_20515_.m_20615_(level);
            } else {
                projectile = new ItemProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModElements.Entities.ITEM_PROJECTILE.get()), level);
                ((ItemProjectileEntity)((Object)projectile)).setItem(itemStackToLaunch.m_41777_());
                barrelPos = SlimeVac.getShootLocVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)0.65f, -1.0, 2.0));
            }
            if (projectile == null) {
                return InteractionResultHolder.m_19098_((Object)handStack);
            }
            Vec3 splitMotion = motion;
            projectile.m_6034_(barrelPos.f_82479_, barrelPos.f_82480_, barrelPos.f_82481_);
            projectile.m_20256_(splitMotion);
            level.m_7967_(projectile);
            projectile.m_5496_(SoundEvents.f_11752_, 1.0f, 0.9f);
            if (slimeFired) {
                player.m_21008_(inverseHand, ItemStack.f_41583_);
            } else if (!player.m_7500_()) {
                player.m_21120_(inverseHand).m_41774_(1);
            }
            player.m_36335_().m_41524_((Item)ModElements.Items.SLIME_VAC.get(), 4);
            return InteractionResultHolder.m_19098_((Object)handStack);
        }
        return InteractionResultHolder.m_19098_((Object)handStack);
    }

    private void leftClick(Player player) {
        if (!player.m_9236_().f_46443_ && this.jammedLargo != null) {
            Vec3 motion;
            SplendidSlime largo = this.getJammedLargo(player.m_9236_(), player);
            Vec3 lookVec = player.m_20154_();
            Vec3 splitMotion = motion = lookVec.m_82541_().m_82490_(2.0).m_82490_(1.5);
            Vec3 barrelPos = SlimeVac.getShootLocVec(player, player.m_7655_() == InteractionHand.MAIN_HAND, new Vec3((double)0.45f, -0.5, 1.0));
            largo.m_6034_(barrelPos.f_82479_, barrelPos.f_82480_, barrelPos.f_82481_);
            largo.m_20256_(splitMotion);
            largo.m_5496_(SoundEvents.f_11752_, 1.0f, 0.9f);
            this.jammedLargo = null;
        }
    }

    public static Vec3 getShootLocVec(Player player, boolean mainHand, Vec3 rightHandForward) {
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        float yaw = (float)((double)(player.m_146908_() / -180.0f) * Math.PI);
        float pitch = (float)((double)(player.m_146909_() / -180.0f) * Math.PI);
        int flip = mainHand == (player.m_5737_() == HumanoidArm.RIGHT) ? -1 : 1;
        Vec3 barrelPosNoTransform = new Vec3((double)flip * rightHandForward.f_82479_, rightHandForward.f_82480_, rightHandForward.f_82481_);
        Vec3 barrelPos = start.m_82549_(barrelPosNoTransform.m_82496_(pitch).m_82524_(yaw));
        return barrelPos;
    }

    public static enum VacMode {
        ITEM,
        SLIME,
        BOTH;

    }
}

