/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.network;

import io.github.chakyl.splendidslimes.item.SlimeVac;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SlimeVacModePacket {
    public SlimeVacModePacket() {
    }

    public SlimeVacModePacket(FriendlyByteBuf buffer) {
    }

    public void encode(FriendlyByteBuf buffer) {
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player != null) {
            ItemStack vacItem = player.m_21205_();
            if (!(vacItem.m_41720_() instanceof SlimeVac)) {
                vacItem = player.m_21206_();
            }
            if (!(vacItem.m_41720_() instanceof SlimeVac)) {
                return;
            }
            SlimeVac.VacMode mode = SlimeVac.getMode(vacItem);
            switch (mode) {
                case BOTH: {
                    SlimeVac.setMode(vacItem, SlimeVac.VacMode.SLIME);
                    break;
                }
                case SLIME: {
                    SlimeVac.setMode(vacItem, SlimeVac.VacMode.ITEM);
                    break;
                }
                case ITEM: {
                    SlimeVac.setMode(vacItem, SlimeVac.VacMode.BOTH);
                }
            }
            Float pitch = Float.valueOf(0.0f);
            switch (mode) {
                case BOTH: {
                    pitch = Float.valueOf(0.7f);
                    break;
                }
                case SLIME: {
                    pitch = Float.valueOf(0.8f);
                    break;
                }
                case ITEM: {
                    pitch = Float.valueOf(0.9f);
                }
            }
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)SoundEvents.f_12218_.get())), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, pitch.floatValue(), 1L));
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"info.splendid_slimes.slime_vac.mode_set", (Object[])new Object[]{SlimeVac.getMode(vacItem)})));
        }
    }
}

