/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.chakyl.splendidslimes.registry.ModElements;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlortRippingRecipe
implements Recipe<SimpleContainer> {
    private final Ingredient ingredient;
    private final ItemStack input;
    private final NonNullList<ItemStack> results;
    private final List<Integer> weights;
    private final ResourceLocation id;

    public PlortRippingRecipe(Ingredient ingredient, ItemStack input, NonNullList<ItemStack> results, List<Integer> weights, ResourceLocation id) {
        this.ingredient = ingredient;
        this.input = input;
        this.results = results;
        this.weights = weights;
        this.id = id;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return this.input.equals(pContainer.m_8020_(0), true);
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return ((ItemStack)this.results.get(0)).m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getInputItem(RegistryAccess pRegistryAccess) {
        return this.input.m_41777_();
    }

    public NonNullList<ItemStack> getResults(RegistryAccess pRegistryAccess) {
        return this.results;
    }

    public List<Integer> getWeights(RegistryAccess pRegistryAccess) {
        return this.weights;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ((ItemStack)this.results.get(0)).m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModElements.Recipes.PLORT_RIPPING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<PlortRippingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plort_ripping";
    }

    public static class Serializer
    implements RecipeSerializer<PlortRippingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("splendid_slimes", "plort_ripping");

        public PlortRippingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            JsonArray resultJson = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"results");
            NonNullList results = NonNullList.m_122780_((int)resultJson.size(), (Object)Items.f_41852_.m_7968_());
            ArrayList<Integer> weights = new ArrayList<Integer>();
            for (int i = 0; i < resultJson.size(); ++i) {
                JsonObject itemStackJson = new JsonObject();
                JsonObject thisJson = resultJson.get(i).getAsJsonObject();
                itemStackJson.add("item", thisJson.get("item"));
                itemStackJson.add("count", thisJson.get("count"));
                results.set(i, (Object)ShapedRecipe.m_151274_((JsonObject)itemStackJson));
                if (thisJson.has("weight")) {
                    weights.add(thisJson.get("weight").getAsInt());
                    continue;
                }
                weights.add(1);
            }
            ItemStack inputItem = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"));
            Ingredient ingredientItem = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"));
            return new PlortRippingRecipe(ingredientItem, inputItem, (NonNullList<ItemStack>)results, weights, pRecipeId);
        }

        @Nullable
        public PlortRippingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int i;
            Ingredient recipeIngredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack input = pBuffer.m_130267_();
            NonNullList results = NonNullList.m_122780_((int)pBuffer.m_130242_(), (Object)Items.f_41852_.m_7968_());
            ArrayList<Integer> weights = new ArrayList<Integer>();
            for (i = 0; i < results.size(); ++i) {
                results.set(i, (Object)pBuffer.m_130267_());
            }
            for (i = 0; i < results.size(); ++i) {
                weights.add(pBuffer.m_130242_());
            }
            return new PlortRippingRecipe(recipeIngredient, input, (NonNullList<ItemStack>)results, weights, pRecipeId);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PlortRippingRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.writeItemStack(pRecipe.getInputItem(null), false);
            pBuffer.m_130130_(pRecipe.getResults(null).size());
            for (ItemStack result : pRecipe.getResults(null)) {
                pBuffer.writeItemStack(result, false);
            }
            for (Integer weight : pRecipe.getWeights(null)) {
                pBuffer.m_130130_(weight.intValue());
            }
        }
    }
}

