/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axWorldGen;

import dev.akatriggered.g1axWorldGen.generator.BadlandsWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.DesertWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.EndWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.IceWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.MushroomWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.NetherWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.PlainsWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.SnowWorldGenerator;
import dev.akatriggered.g1axWorldGen.generator.VoidWorldGenerator;
import dev.akatriggered.g1axWorldGen.utils.TextStyle;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class G1axWorldGenerator
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.sendConsoleMessage("<#0398fc>G1axWorldGenerator</#0398fc>", "<gray>Enabled</gray>");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        this.sendConsoleMessage("<red>G1axWorldGenerator</red>", "<gray>Disabled</gray>");
    }

    private void sendConsoleMessage(String title, String status) {
        String[] lines;
        for (String line : lines = new String[]{"", "<#2b5dad>  \u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557  \u2588\u2588\u2557</#2b5dad>", "<#2b5dad> \u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d \u2588\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u255a\u2588\u2588\u2557\u2588\u2588\u2554\u255d</#2b5dad>", "<#2b5dad> \u2588\u2588\u2551  \u2588\u2588\u2588\u2557\u255a\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551 \u255a\u2588\u2588\u2588\u2554\u255d</#2b5dad>", "<#2b5dad> \u2588\u2588\u2551   \u2588\u2588\u2551 \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2551 \u2588\u2588\u2554\u2588\u2588\u2557</#2b5dad>", "<#2b5dad> \u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d \u2588\u2588\u2551\u2588\u2588\u2551  \u2588\u2588\u2551\u2588\u2588\u2554\u255d \u2588\u2588\u2557</#2b5dad>", "<#2b5dad>  \u255a\u2550\u2550\u2550\u2550\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d</#2b5dad>", "  " + title + " v1.0.0 - " + status, "  <gray>Custom World Generator</gray>", ""}) {
            Bukkit.getConsoleSender().sendMessage(TextStyle.parse(line));
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        if ("DESERT".equalsIgnoreCase(id)) {
            return new DesertWorldGenerator();
        }
        if ("BADLANDS".equalsIgnoreCase(id)) {
            return new BadlandsWorldGenerator();
        }
        if ("MUSHROOM".equalsIgnoreCase(id)) {
            return new MushroomWorldGenerator();
        }
        if ("PLAINS".equalsIgnoreCase(id)) {
            return new PlainsWorldGenerator();
        }
        if ("END".equalsIgnoreCase(id)) {
            return new EndWorldGenerator();
        }
        if ("NETHER".equalsIgnoreCase(id)) {
            return new NetherWorldGenerator();
        }
        if ("SNOW".equalsIgnoreCase(id)) {
            return new SnowWorldGenerator();
        }
        if ("ICE".equalsIgnoreCase(id)) {
            return new IceWorldGenerator();
        }
        if ("VOID".equalsIgnoreCase(id)) {
            return new VoidWorldGenerator();
        }
        return null;
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        if (world.getGenerator() instanceof BadlandsWorldGenerator || world.getGenerator() instanceof DesertWorldGenerator || world.getGenerator() instanceof EndWorldGenerator || world.getGenerator() instanceof IceWorldGenerator || world.getGenerator() instanceof MushroomWorldGenerator || world.getGenerator() instanceof NetherWorldGenerator || world.getGenerator() instanceof PlainsWorldGenerator || world.getGenerator() instanceof SnowWorldGenerator || world.getGenerator() instanceof VoidWorldGenerator) {
            world.setDifficulty(Difficulty.HARD);
            world.setSpawnFlags(false, false);
            world.setKeepSpawnInMemory(false);
            world.getWorldBorder().setSize(1000.0);
            world.setAutoSave(false);
            world.setTicksPerAnimalSpawns(0);
            world.setTicksPerMonsterSpawns(0);
            world.setTicksPerWaterSpawns(0);
            world.setTicksPerWaterAmbientSpawns(0);
            world.setTicksPerAmbientSpawns(0);
            world.setViewDistance(6);
            world.setSimulationDistance(4);
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
            world.setGameRule(GameRule.DO_FIRE_TICK, (Object)false);
            world.setGameRule(GameRule.MOB_GRIEFING, (Object)false);
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)0);
            world.setGameRule(GameRule.DO_TILE_DROPS, (Object)false);
            world.setGameRule(GameRule.DO_ENTITY_DROPS, (Object)false);
            world.setGameRule(GameRule.KEEP_INVENTORY, (Object)false);
            world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
            world.setTime(6000L);
            world.setStorm(false);
            world.setThundering(false);
        }
    }
}

