/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axWorldGen.generator;

import dev.akatriggered.g1axWorldGen.utils.NoiseUtil;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;

public class BadlandsWorldGenerator
extends ChunkGenerator {
    private final NoiseUtil noiseUtil = new NoiseUtil();
    private final Random random = new Random();

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunk = this.createChunkData(world);
        int seaLevel = 63;
        int scale = 64;
        int duneAmplitude = 5;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = chunkX * 16 + x;
                int worldZ = chunkZ * 16 + z;
                float mainNoise = this.noiseUtil.getMainNoise(worldX, worldZ);
                float duneNoise = this.noiseUtil.getDuneNoise(worldX, worldZ);
                int height = seaLevel + (int)(0.125 * (double)scale + (double)mainNoise * 0.05 * (double)scale);
                this.setTerrainBlocks(chunk, x, z, height += (int)(Math.max(0.0f, duneNoise) * (float)duneAmplitude));
                this.decorateSurface(chunk, x, z, height);
                biome.setBiome(x, z, Biome.BADLANDS);
            }
        }
        return chunk;
    }

    private void setTerrainBlocks(ChunkGenerator.ChunkData chunk, int x, int z, int height) {
        for (int y = -64; y <= height; ++y) {
            if (y <= -59) {
                chunk.setBlock(x, y, z, Material.BEDROCK);
                continue;
            }
            if (y <= -1) {
                chunk.setBlock(x, y, z, Material.DEEPSLATE);
                continue;
            }
            if (y == 0) {
                chunk.setBlock(x, y, z, Material.DEEPSLATE);
                continue;
            }
            if (y >= height - 3) {
                chunk.setBlock(x, y, z, Material.RED_SAND);
                continue;
            }
            if (y >= height - 7) {
                chunk.setBlock(x, y, z, Material.TERRACOTTA);
                continue;
            }
            chunk.setBlock(x, y, z, Material.STONE);
        }
    }

    private void decorateSurface(ChunkGenerator.ChunkData chunk, int x, int z, int height) {
        if ((double)this.random.nextFloat() < 0.002) {
            int cactusHeight = this.random.nextInt(3) + 1;
            for (int y = 0; y < cactusHeight; ++y) {
                chunk.setBlock(x, height + 1 + y, z, Material.CACTUS);
            }
        } else if ((double)this.random.nextFloat() < 0.004) {
            chunk.setBlock(x, height + 1, z, Material.DEAD_BUSH);
        }
    }
}

