/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axWorldGen.generator;

import dev.akatriggered.g1axWorldGen.populator.NetherPopulator;
import dev.akatriggered.g1axWorldGen.utils.NoiseUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class NetherWorldGenerator
extends ChunkGenerator {
    private final NoiseUtil noiseUtil = new NoiseUtil();

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunk = this.createChunkData(world);
        int baseLevel = 32;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = chunkX * 16 + x;
                int worldZ = chunkZ * 16 + z;
                float mainNoise = this.noiseUtil.getMainNoise(worldX, worldZ);
                int height = baseLevel + (int)(mainNoise * 30.0f);
                this.setTerrainBlocks(chunk, x, z, height);
                biome.setBiome(x, z, Biome.NETHER_WASTES);
            }
        }
        return chunk;
    }

    private void setTerrainBlocks(ChunkGenerator.ChunkData chunk, int x, int z, int height) {
        for (int y = -64; y <= height; ++y) {
            if (y <= -59) {
                chunk.setBlock(x, y, z, Material.BEDROCK);
                continue;
            }
            if (y < height) {
                chunk.setBlock(x, y, z, Material.NETHERRACK);
                continue;
            }
            chunk.setBlock(x, y, z, Material.NETHERRACK);
        }
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        return Arrays.asList(new BlockPopulator[]{new NetherPopulator()});
    }
}

