/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axWorldGen.generator;

import dev.akatriggered.g1axWorldGen.populator.SnowPopulator;
import dev.akatriggered.g1axWorldGen.utils.NoiseUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class SnowWorldGenerator
extends ChunkGenerator {
    private final NoiseUtil noiseUtil = new NoiseUtil();

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunk = this.createChunkData(world);
        int seaLevel = 63;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = chunkX * 16 + x;
                int worldZ = chunkZ * 16 + z;
                float mainNoise = this.noiseUtil.getMainNoise(worldX, worldZ);
                int height = seaLevel + (int)(mainNoise * 20.0f);
                this.setTerrainBlocks(chunk, x, z, height);
                biome.setBiome(x, z, Biome.SNOWY_PLAINS);
            }
        }
        return chunk;
    }

    private void setTerrainBlocks(ChunkGenerator.ChunkData chunk, int x, int z, int height) {
        for (int y = -64; y <= height + 1; ++y) {
            if (y <= -59) {
                chunk.setBlock(x, y, z, Material.BEDROCK);
                continue;
            }
            if (y <= 0) {
                chunk.setBlock(x, y, z, Material.DEEPSLATE);
                continue;
            }
            if (y <= height - 4) {
                chunk.setBlock(x, y, z, Material.STONE);
                continue;
            }
            if (y < height) {
                chunk.setBlock(x, y, z, Material.DIRT);
                continue;
            }
            if (y == height) {
                chunk.setBlock(x, y, z, Material.GRASS_BLOCK);
                continue;
            }
            chunk.setBlock(x, y, z, Material.SNOW);
        }
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        return Arrays.asList(new BlockPopulator[]{new SnowPopulator()});
    }
}

