/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core.lib;

import com.google.common.eventbus.EventBus;
import com.midnight.liteloaderloader.core.lib.ReflectionHelper;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.ModInfo;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LiteloaderModContainer
implements ModContainer {
    private static List<LiteloaderModContainer> containers = null;
    private final ModInfo<?> mod;
    private final ModMetadata metadata;

    public LiteloaderModContainer(ModInfo<?> mod) {
        this.mod = mod;
        this.metadata = new ModMetadata();
        this.metadata.modId = mod.getModClassName();
        this.metadata.name = mod.getDisplayName();
        this.metadata.version = mod.getVersion();
        this.metadata.authorList = new ArrayList();
        this.metadata.authorList.add(mod.getAuthor());
        this.metadata.description = mod.getDescription();
        this.metadata.url = mod.getURL();
    }

    public static void populate(ArrayList<ModContainer> list) {
        if (containers == null) {
            LiteloaderModContainer.initModlist();
        }
        list.addAll(containers);
    }

    public static void initModlist() {
        containers = new ArrayList<LiteloaderModContainer>();
        LiteLoaderMods llmods = ReflectionHelper.getLiteLoaderMods();
        for (ModInfo mod : llmods.getAllMods()) {
            containers.add(new LiteloaderModContainer(mod));
        }
    }

    public String getModId() {
        return this.metadata.name.replace(" ", "_");
    }

    public String getName() {
        return this.metadata.name;
    }

    public String getVersion() {
        return this.mod.getVersion();
    }

    public File getSource() {
        return this.mod.getContainer().toFile();
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public void bindMetadata(MetadataCollection mc) {
    }

    public void setEnabledState(boolean enabled) {
    }

    public Set<ArtifactVersion> getRequirements() {
        return null;
    }

    public List<ArtifactVersion> getDependencies() {
        return null;
    }

    public List<ArtifactVersion> getDependants() {
        return null;
    }

    public String getSortingRules() {
        return "";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        return false;
    }

    public boolean matches(Object mod) {
        return false;
    }

    public Object getMod() {
        return null;
    }

    public ArtifactVersion getProcessedVersion() {
        return null;
    }

    public boolean isImmutable() {
        return false;
    }

    public String getDisplayVersion() {
        return this.mod.getVersion();
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return null;
    }

    public Certificate getSigningCertificate() {
        return null;
    }

    public Map<String, String> getCustomModProperties() {
        return null;
    }

    public Class<?> getCustomResourcePackClass() {
        return null;
    }

    public Map<String, String> getSharedModDescriptor() {
        return null;
    }

    public ModContainer.Disableable canBeDisabled() {
        return ModContainer.Disableable.RESTART;
    }

    public String getGuiClassName() {
        return "";
    }

    public List<String> getOwnedPackages() {
        return null;
    }
}

