/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core.transformers.forge;

import com.google.common.collect.ImmutableList;
import com.midnight.liteloaderloader.core.lib.ReflectionHelper;
import com.midnight.liteloaderloader.core.transformers.ClassTransformer;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FMLCommonHandlerTransformer
extends ClassTransformer {
    public FMLCommonHandlerTransformer() {
        this.methodTransforms.put("computeBranding", this::transformComputeBranding);
    }

    private void transformComputeBranding(MethodNode methodNode) {
        MethodInsnNode lastAdd = null;
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode min = (MethodInsnNode)insn;
            if (!min.owner.equals("com/google/common/collect/ImmutableList$Builder") || !min.name.equals("add") || !min.desc.equals("(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;")) continue;
            lastAdd = min;
        }
        if (lastAdd != null) {
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/midnight/liteloaderloader/core/transformers/forge/FMLCommonHandlerTransformer", "addBranding", "(Lcom/google/common/collect/ImmutableList$Builder;)V", false));
            methodNode.instructions.insert((AbstractInsnNode)lastAdd, toInject);
        }
    }

    public static void addBranding(ImmutableList.Builder<String> builder) {
        LiteLoaderMods llmods = ReflectionHelper.getLiteLoaderMods();
        int total = llmods.getAllMods().size();
        int active = llmods.getLoadedMods().size();
        builder.add((Object)String.format("%d LiteLoader mod%s loaded, %d mod%s active", total, total != 1 ? "s" : "", active, active != 1 ? "s" : ""));
    }
}

