/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core;

import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.nio.file.Paths;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class LiteloaderLoader
implements IFMLLoadingPlugin {
    public static boolean overrideProgressBar = true;
    public static boolean angelicaEventCompat = true;
    public static boolean voxelCommonNixCompat = true;
    public static boolean macroKeybindModLogSpam = true;
    public static boolean addToForgeCounts = false;
    public static Logger LOG = LogManager.getLogger((String)"LiteloaderLoader");

    public LiteloaderLoader() {
        String configPath = Paths.get("config", "liteloaderloader.cfg").toString();
        File file = new File(configPath);
        Configuration config = new Configuration(file);
        overrideProgressBar = config.getBoolean("overrideProgressBar", "general", true, "If true, LiteLoader's progress bar will be replaced with a custom implementation that works better with Forge.");
        angelicaEventCompat = config.getBoolean("angelicaEventCompat", "general", true, "Fixes Angelica's HUD Caching module to ensure some events are fired correctly. This is required for VoxelMap and possibly other mods.");
        voxelCommonNixCompat = config.getBoolean("voxelCommonNixCompat", "general", true, "Patches VoxelCommonLiteMod to fix issues on non-Windows OSes involving the TEMP environment variable.");
        macroKeybindModLogSpam = config.getBoolean("macroKeybindModLogSpam", "general", true, "Patches Macro Keybind Mod to reduce log spam due to missing fields in lwjgl3.");
        addToForgeCounts = config.getBoolean("addToModList", "general", true, "If true, LiteLoader mods will be added to both the ingame Forge modlist and mod counts on the main menu.");
        try {
            Mouse.class.getDeclaredField("readBuffer");
            Keyboard.class.getDeclaredField("readBuffer");
            macroKeybindModLogSpam = false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public String[] getASMTransformerClass() {
        return new String[]{"com.midnight.liteloaderloader.core.transformers.LLLTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

