/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core;

import com.midnight.liteloaderloader.core.LiteloaderLoader;
import com.midnight.liteloaderloader.core.transformers.ClassOverlayTransformerTransformer;
import com.midnight.liteloaderloader.core.transformers.EventTransformer;
import com.midnight.liteloaderloader.core.transformers.compat.AngelicaHUDCachingTransformer;
import com.midnight.liteloaderloader.lib.Tuple;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.launchwrapper.IClassTransformer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.FieldVisitor;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;

public class LiteloaderTransformer
implements IClassTransformer {
    private static final String[] transformedNamespaces = new String[]{"com.mumfrey.liteloader", "net.eq2online"};
    private static final HashMap<String, Tuple<String, Tuple<Integer, Integer>>> toKill = new HashMap();
    private static final HashMap<String, Function<byte[], byte[]>> transformations = new HashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformations.containsKey(transformedName)) {
            LiteloaderLoader.LOG.info("Applying transformation for {}", new Object[]{transformedName});
            basicClass = transformations.get(transformedName).apply(basicClass);
        }
        for (String namespace : transformedNamespaces) {
            if (!transformedName.startsWith(namespace)) continue;
            byte[] transformedClass = this.applyTransformation(basicClass, transformedName);
            if (!Arrays.equals(transformedClass, basicClass)) {
                LiteloaderLoader.LOG.info("Transformed {}", new Object[]{transformedName});
            }
            return transformedClass;
        }
        return basicClass;
    }

    private byte[] applyTransformation(byte[] basicClass, String transformedName) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassWriter classWriter = new ClassWriter(0);
        LiteloaderClassVisitor classVisitor = new LiteloaderClassVisitor(589824, (ClassVisitor)classWriter, transformedName);
        classReader.accept((ClassVisitor)classVisitor, 0);
        return classWriter.toByteArray();
    }

    static String remapString(String str) {
        return str == null ? null : str.replace("org/objectweb/asm/", "org/spongepowered/asm/lib/").replace("RemappingAnnotationAdapter", "AnnotationRemapper").replace("RemappingFieldAdapter", "FieldRemapper").replace("RemappingMethodAdapter", "MethodRemapper").replace("RemappingClassAdapter", "ClassRemapper");
    }

    private static String getClassName(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        return lastDotIndex == -1 ? name : name.substring(lastDotIndex + 1);
    }

    static {
        transformations.put("com.gtnewhorizons.angelica.hudcaching.HUDCaching", bytes -> new AngelicaHUDCachingTransformer().apply((byte[])bytes));
        transformations.put("com.mumfrey.liteloader.transformers.event.Event", bytes -> new EventTransformer().apply((byte[])bytes));
        transformations.put("com.mumfrey.liteloader.transformers.ClassOverlayTransformer", bytes -> new ClassOverlayTransformerTransformer().apply((byte[])bytes));
        toKill.put("CrashReportTransformer", Tuple.of("transform", Tuple.of(176, 3)));
        toKill.put("MinecraftOverlayTransformer", Tuple.of("postOverlayTransform", Tuple.of(177, null)));
        toKill.put("LiteLoaderBootstrap", Tuple.of("preBeginGame", Tuple.of(177, null)));
        try {
            Mouse.class.getDeclaredField("readBuffer");
            Keyboard.class.getDeclaredField("readBuffer");
        }
        catch (NoSuchFieldException e) {
            toKill.put("InputHandler", Tuple.of("getBuffers", Tuple.of(177, null)));
        }
    }

    static class LiteloaderClassVisitor
    extends ClassVisitor {
        private final String transformedName;

        public LiteloaderClassVisitor(int api, ClassVisitor classVisitor, String transformedName) {
            super(api, classVisitor);
            this.transformedName = transformedName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            for (int i = 0; i < interfaces.length; ++i) {
                interfaces[i] = LiteloaderTransformer.remapString(interfaces[i]);
            }
            super.visit(version, access, LiteloaderTransformer.remapString(name), LiteloaderTransformer.remapString(signature), LiteloaderTransformer.remapString(superName), interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return super.visitField(access, LiteloaderTransformer.remapString(name), LiteloaderTransformer.remapString(desc), LiteloaderTransformer.remapString(signature), value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, LiteloaderTransformer.remapString(name), LiteloaderTransformer.remapString(desc), LiteloaderTransformer.remapString(signature), exceptions);
            return new LiteloaderMethodVisitor(this.api, mv, this.transformedName, name);
        }
    }

    static class LiteloaderMethodVisitor
    extends MethodVisitor {
        private final String className;
        private final String name;

        public LiteloaderMethodVisitor(int api, MethodVisitor methodVisitor, String className, String name) {
            super(api, methodVisitor);
            this.className = className;
            this.name = name;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 183 && owner.endsWith("ClassWriter") && name.equals("<init>") && descriptor.endsWith("I)V")) {
                super.visitInsn(87);
                super.visitLdcInsn((Object)1);
            }
            super.visitMethodInsn(opcode, LiteloaderTransformer.remapString(owner), LiteloaderTransformer.remapString(name), LiteloaderTransformer.remapString(descriptor), isInterface);
        }

        public void visitLdcInsn(Object value) {
            if (value instanceof String) {
                String str = (String)value;
                value = LiteloaderTransformer.remapString(str);
            }
            super.visitLdcInsn(value);
        }

        public void visitTypeInsn(int opcode, String type) {
            super.visitTypeInsn(opcode, LiteloaderTransformer.remapString(type));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            super.visitFieldInsn(opcode, LiteloaderTransformer.remapString(owner), LiteloaderTransformer.remapString(name), LiteloaderTransformer.remapString(descriptor));
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            String str;
            Object object;
            int i;
            if (local != null) {
                for (i = 0; i < local.length; ++i) {
                    object = local[i];
                    if (!(object instanceof String)) continue;
                    str = (String)object;
                    local[i] = LiteloaderTransformer.remapString(str);
                }
            }
            if (stack != null) {
                for (i = 0; i < stack.length; ++i) {
                    object = stack[i];
                    if (!(object instanceof String)) continue;
                    str = (String)object;
                    stack[i] = LiteloaderTransformer.remapString(str);
                }
            }
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        public void visitCode() {
            String truncatedName = LiteloaderTransformer.getClassName(this.className);
            if (truncatedName.equals("ClassOverlayTransformer")) {
                if (this.name.equals("transform")) {
                    this.visitVarInsn(25, 1);
                    this.transformClassOverlayMethod(3);
                } else if (this.name.equals("applyOverlay")) {
                    this.visitVarInsn(25, 0);
                    this.visitFieldInsn(180, this.className.replace(".", "/"), "overlayClassName", "Ljava/lang/String;");
                    this.transformClassOverlayMethod(2);
                }
            }
            if (toKill.containsKey(truncatedName)) {
                Tuple tuple = (Tuple)toKill.get(truncatedName);
                Tuple instructionInfo = (Tuple)tuple.getSecond();
                if (this.name.equals(tuple.getFirst())) {
                    if ((Integer)instructionInfo.getFirst() == 176) {
                        this.visitVarInsn(25, (Integer)instructionInfo.getSecond());
                        this.visitInsn(176);
                    } else if ((Integer)instructionInfo.getFirst() == 177) {
                        this.visitInsn(177);
                    }
                    return;
                }
            }
            super.visitCode();
        }

        private void transformClassOverlayMethod(int index) {
            this.visitLdcInsn("com.mumfrey.liteloader.client.overlays.MinecraftOverlay");
            this.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            Label notEqual = new Label();
            this.visitJumpInsn(153, notEqual);
            this.visitVarInsn(25, index);
            this.visitInsn(176);
            this.visitLabel(notEqual);
            this.visitFrame(3, 0, null, 0, null);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(LiteloaderTransformer.remapString(name), LiteloaderTransformer.remapString(desc), signature != null ? LiteloaderTransformer.remapString(signature) : null, start, end, index);
        }
    }
}

