/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core.transformers;

import com.midnight.liteloaderloader.core.LiteloaderLoader;
import java.util.HashMap;
import java.util.function.Consumer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodNode;

public abstract class ClassTransformer {
    protected final HashMap<String, Consumer<MethodNode>> methodTransforms = new HashMap();

    public byte[] apply(byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!this.methodTransforms.containsKey(method.name)) continue;
            LiteloaderLoader.LOG.info("Transforming method: {} in class: {}", new Object[]{method.name, node.name});
            int insCount = method.instructions.size();
            this.methodTransforms.get(method.name).accept(method);
            LiteloaderLoader.LOG.info("Transformed {}. Instruction count: {} (was {})", new Object[]{method.name, method.instructions.size(), insCount});
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

