/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public final class SafeClassWriter
extends ClassWriter {
    public SafeClassWriter(int flags) {
        super(flags);
    }

    public SafeClassWriter(ClassReader cr, int flags) {
        super(cr, flags);
    }

    protected String getCommonSuperClass(String a, String b) {
        try {
            ClassLoader cl = SafeClassWriter.class.getClassLoader();
            Class<?> c1 = Class.forName(a.replace('/', '.'), false, cl);
            Class<?> c2 = Class.forName(b.replace('/', '.'), false, cl);
            if (c1.isAssignableFrom(c2)) {
                return a;
            }
            if (c2.isAssignableFrom(c1)) {
                return b;
            }
            if (c1.isInterface() || c2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c1 = c1.getSuperclass()).isAssignableFrom(c2)) {
            }
            return c1.getName().replace('.', '/');
        }
        catch (Throwable t) {
            return "java/lang/Object";
        }
    }
}

