/*
 * Decompiled with CFR 0.152.
 */
package com.midnight.liteloaderloader.core.transformers;

import com.midnight.liteloaderloader.core.LiteloaderLoader;
import com.midnight.liteloaderloader.core.transformers.ClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ClassTransformerTransformer
extends ClassTransformer {
    public ClassTransformerTransformer() {
        this.methodTransforms.put("writeClass", this::transformWriteClass);
    }

    private void transformWriteClass(MethodNode method) {
        String CW = "org/objectweb/asm/ClassWriter";
        String MCW = "com/midnight/liteloaderloader/core/SafeClassWriter";
        for (AbstractInsnNode insn : method.instructions.toArray()) {
            if (insn.getOpcode() == 187) {
                TypeInsnNode t = (TypeInsnNode)insn;
                if (!"org/objectweb/asm/ClassWriter".equals(t.desc)) continue;
                LiteloaderLoader.LOG.info("Transform: NEW ClassWriter -> SafeClassWriter in {}", new Object[]{method.name});
                t.desc = "com/midnight/liteloaderloader/core/SafeClassWriter";
                continue;
            }
            if (insn.getOpcode() != 183 || !(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode m = (MethodInsnNode)insn;
            if (!"org/objectweb/asm/ClassWriter".equals(m.owner) || !"<init>".equals(m.name)) continue;
            LiteloaderLoader.LOG.info("Transform: <init> owner ClassWriter -> SafeClassWriter in {}", new Object[]{method.name});
            m.owner = "com/midnight/liteloaderloader/core/SafeClassWriter";
        }
    }
}

